/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.state;

import com.google.common.collect.ImmutableMap;
import io.camunda.zeebe.dynamic.config.state.ExporterState;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public record ExportersConfig(Map<String, ExporterState> exporters) {
    public static ExportersConfig empty() {
        return new ExportersConfig(Map.of());
    }

    private ExportersConfig updateExporter(String exporterName, ExporterState exporterState) {
        ImmutableMap newExporters = ImmutableMap.builder().putAll(this.exporters).put((Object)exporterName, (Object)exporterState).buildKeepingLast();
        return new ExportersConfig((Map<String, ExporterState>)newExporters);
    }

    public ExportersConfig disableExporter(String exporterName) {
        return this.updateExporter(exporterName, new ExporterState(this.exporters.get(exporterName).metadataVersion(), ExporterState.State.DISABLED, Optional.empty()));
    }

    public ExportersConfig disableExporters(Collection<String> exporterNames) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.exporters);
        exporterNames.forEach(exporterName -> builder.put(exporterName, (Object)new ExporterState(this.exporters.get(exporterName).metadataVersion(), ExporterState.State.DISABLED, Optional.empty())));
        ImmutableMap newExporters = builder.buildKeepingLast();
        return new ExportersConfig((Map<String, ExporterState>)newExporters);
    }

    public ExportersConfig enableExporter(String exporterName, long metadataVersion) {
        return this.enableExporter(exporterName, null, metadataVersion);
    }

    public ExportersConfig enableExporter(String exporterName, String initializeFrom, long metadataVersion) {
        return this.updateExporter(exporterName, new ExporterState(metadataVersion, ExporterState.State.ENABLED, Optional.ofNullable(initializeFrom)));
    }

    public ExportersConfig addExporters(Collection<String> exporterNames) {
        exporterNames.forEach(exporterName -> {
            if (this.exporters.containsKey(exporterName)) {
                throw new IllegalArgumentException(String.format("Exporter '%s' already exists in the partition", exporterName));
            }
        });
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.exporters);
        exporterNames.forEach(exporterName -> builder.put(exporterName, (Object)new ExporterState(0L, ExporterState.State.ENABLED, Optional.empty())));
        ImmutableMap newExporters = builder.buildKeepingLast();
        return new ExportersConfig((Map<String, ExporterState>)newExporters);
    }
}

