/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.state;

import io.camunda.zeebe.dynamic.config.state.DynamicPartitionConfig;
import java.util.function.UnaryOperator;

public record PartitionState(State state, int priority, DynamicPartitionConfig config) {
    public static PartitionState active(int priority, DynamicPartitionConfig partitionConfig) {
        return new PartitionState(State.ACTIVE, priority, partitionConfig);
    }

    public static PartitionState joining(int priority, DynamicPartitionConfig partitionConfig) {
        return new PartitionState(State.JOINING, priority, partitionConfig);
    }

    public static PartitionState bootstrapping(int priority, DynamicPartitionConfig partitionConfig) {
        return new PartitionState(State.BOOTSTRAPPING, priority, partitionConfig);
    }

    public PartitionState toActive() {
        if (this.state == State.LEAVING) {
            throw new IllegalStateException(String.format("Cannot transition to ACTIVE when current state is %s", new Object[]{this.state}));
        }
        return new PartitionState(State.ACTIVE, this.priority, this.config);
    }

    public PartitionState toLeaving() {
        return new PartitionState(State.LEAVING, this.priority, this.config);
    }

    public PartitionState updateConfig(DynamicPartitionConfig config) {
        return new PartitionState(this.state, this.priority, config);
    }

    public PartitionState updateConfig(UnaryOperator<DynamicPartitionConfig> configUpdater) {
        return new PartitionState(this.state, this.priority, (DynamicPartitionConfig)configUpdater.apply(this.config));
    }

    public static enum State {
        UNKNOWN,
        JOINING,
        ACTIVE,
        LEAVING,
        BOOTSTRAPPING;

    }
}

