/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.state;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public record RoutingState(long version, Set<Integer> activePartitions, MessageCorrelation messageCorrelation) {
    public RoutingState {
        Objects.requireNonNull(activePartitions);
        Objects.requireNonNull(messageCorrelation);
        if (version < 0L) {
            throw new IllegalArgumentException("Version must be positive");
        }
        for (Integer partition : activePartitions) {
            if (partition > 0) continue;
            throw new IllegalArgumentException("Partition id must be positive");
        }
    }

    public RoutingState merge(RoutingState other) {
        if (this.equals(other)) {
            return this;
        }
        if (this.version > other.version) {
            return this;
        }
        if (this.version < other.version) {
            return other;
        }
        throw new IllegalStateException("Cannot merge two different routing states with the same version");
    }

    public static RoutingState initializeWithPartitionCount(int partitionCount) {
        return new RoutingState(1L, IntStream.rangeClosed(1, partitionCount).boxed().collect(Collectors.toSet()), new MessageCorrelation.HashMod(partitionCount));
    }

    public static sealed interface MessageCorrelation {

        public record HashMod(int partitionCount) implements MessageCorrelation
        {
            public HashMod {
                if (partitionCount <= 0) {
                    throw new IllegalArgumentException("Partition count must be positive");
                }
            }
        }
    }
}

