/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.util;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.DynamicPartitionConfig;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.dynamic.config.state.PartitionState;
import io.camunda.zeebe.dynamic.config.state.RoutingState;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class ConfigurationUtil {
    private ConfigurationUtil() {
    }

    public static ClusterConfiguration getClusterConfigFrom(boolean enablePartitionScaling, Set<PartitionMetadata> partitionDistribution, DynamicPartitionConfig partitionConfig) {
        HashMap<MemberId, Map> partitionStatesByMember = new HashMap<MemberId, Map>();
        for (PartitionMetadata partitionMetadata : partitionDistribution) {
            Integer n = (Integer)partitionMetadata.id().id();
            for (MemberId member : partitionMetadata.members()) {
                int memberPriority = partitionMetadata.getPriority(member);
                partitionStatesByMember.computeIfAbsent(member, k -> new HashMap()).put(n, PartitionState.active(memberPriority, partitionConfig));
            }
        }
        HashMap<MemberId, MemberState> memberStates = new HashMap<MemberId, MemberState>();
        for (Map.Entry entry : partitionStatesByMember.entrySet()) {
            memberStates.put((MemberId)entry.getKey(), MemberState.initializeAsActive((Map)entry.getValue()));
        }
        Optional<RoutingState> optional = enablePartitionScaling ? Optional.of(RoutingState.initializeWithPartitionCount(partitionDistribution.size())) : Optional.empty();
        return new ClusterConfiguration(1L, Map.copyOf(memberStates), Optional.empty(), Optional.empty(), optional);
    }

    public static Set<PartitionMetadata> getPartitionDistributionFrom(ClusterConfiguration clusterConfiguration, String groupName) {
        if (clusterConfiguration.isUninitialized()) {
            throw new IllegalStateException("Cannot generated partition distribution from uninitialized configuration");
        }
        HashMap memberPriorityByPartition = new HashMap();
        clusterConfiguration.members().forEach((memberId, member) -> {
            for (Map.Entry<Integer, PartitionState> entry : member.partitions().entrySet()) {
                Integer partitionId = entry.getKey();
                PartitionState partitionState = entry.getValue();
                if (!partitionState.state().equals((Object)PartitionState.State.ACTIVE) && !partitionState.state().equals((Object)PartitionState.State.LEAVING)) continue;
                memberPriorityByPartition.computeIfAbsent(partitionId, k -> new HashMap()).put(memberId, partitionState.priority());
            }
        });
        return memberPriorityByPartition.entrySet().stream().map(e -> ConfigurationUtil.getPartitionMetadata(e, groupName)).collect(Collectors.toSet());
    }

    private static PartitionMetadata getPartitionMetadata(Map.Entry<Integer, Map<MemberId, Integer>> e, String groupName) {
        Map<MemberId, Integer> memberPriorities = e.getValue();
        Optional optionalPrimary = memberPriorities.entrySet().stream().max(Map.Entry.comparingByValue());
        if (optionalPrimary.isEmpty()) {
            throw new IllegalStateException("Found partition with no members");
        }
        return new PartitionMetadata(ConfigurationUtil.partitionId(e.getKey(), groupName), memberPriorities.keySet(), memberPriorities, ((Integer)optionalPrimary.get().getValue()).intValue(), (MemberId)optionalPrimary.get().getKey());
    }

    private static PartitionId partitionId(Integer key, String groupName) {
        return PartitionId.from((String)groupName, (int)key);
    }
}

