/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.topology.TopologyUpdateNotifier;
import io.camunda.zeebe.topology.gossip.ClusterTopologyGossiper;
import io.camunda.zeebe.topology.gossip.ClusterTopologyGossiperConfig;
import io.camunda.zeebe.topology.metrics.TopologyMetrics;
import io.camunda.zeebe.topology.serializer.ProtoBufSerializer;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.micrometer.core.instrument.MeterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayClusterTopologyService
extends Actor
implements TopologyUpdateNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(GatewayClusterTopologyService.class);
    private final ClusterTopologyGossiper clusterTopologyGossiper;
    private ClusterTopology clusterTopology = ClusterTopology.uninitialized();
    private final TopologyMetrics topologyMetrics;

    public GatewayClusterTopologyService(ClusterCommunicationService communicationService, ClusterMembershipService memberShipService, ClusterTopologyGossiperConfig config, MeterRegistry meterRegistry) {
        this.topologyMetrics = new TopologyMetrics(meterRegistry);
        this.clusterTopologyGossiper = new ClusterTopologyGossiper((ConcurrencyControl)this, communicationService, memberShipService, new ProtoBufSerializer(), config, this::updateClusterTopology, this.topologyMetrics);
    }

    private void updateClusterTopology(ClusterTopology clusterTopology) {
        this.actor.run(() -> {
            if (clusterTopology == null || clusterTopology.isUninitialized()) {
                return;
            }
            try {
                ClusterTopology mergedTopology = this.clusterTopology.merge(clusterTopology);
                if (mergedTopology.equals(this.clusterTopology)) {
                    return;
                }
                LOG.debug("Received new topology {}. Updating local topology to {}", (Object)clusterTopology, (Object)mergedTopology);
                this.clusterTopology = mergedTopology;
                this.clusterTopologyGossiper.updateClusterTopology(this.clusterTopology);
            }
            catch (Exception updateFailed) {
                LOG.warn("Failed to process received topology update {}", (Object)clusterTopology, (Object)updateFailed);
            }
        });
    }

    protected void onActorStarting() {
        this.clusterTopologyGossiper.start();
    }

    protected void onActorClosing() {
        this.clusterTopologyGossiper.close();
    }

    @Override
    public void addUpdateListener(TopologyUpdateNotifier.TopologyUpdateListener listener) {
        this.clusterTopologyGossiper.addUpdateListener(listener);
    }

    @Override
    public void removeUpdateListener(TopologyUpdateNotifier.TopologyUpdateListener listener) {
        this.clusterTopologyGossiper.removeUpdateListener(listener);
    }
}

