/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.camunda.zeebe.topology.PartitionDistributor;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.util.TopologyUtil;
import java.util.List;
import java.util.Set;

public record StaticConfiguration(PartitionDistributor partitionDistributor, Set<MemberId> clusterMembers, MemberId localMemberId, List<PartitionId> partitionIds, int replicationFactor) {
    public ClusterTopology generateTopology() {
        Set<PartitionMetadata> partitionDistribution = this.generatePartitionDistribution();
        return TopologyUtil.getClusterTopologyFrom(partitionDistribution);
    }

    public Set<PartitionMetadata> generatePartitionDistribution() {
        List<PartitionId> sortedPartitionIds = this.partitionIds.stream().sorted().toList();
        return this.partitionDistributor.distributePartitions(this.clusterMembers, sortedPartitionIds, this.replicationFactor);
    }
}

