/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.api;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.topology.api.TopologyRequestFailedException;
import io.camunda.zeebe.topology.changes.TopologyChangeCoordinator;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ForceScaleDownRequestTransformer
implements TopologyChangeCoordinator.TopologyChangeRequest {
    private final Set<MemberId> membersToRetain;
    private final MemberId coordinator;

    public ForceScaleDownRequestTransformer(Set<MemberId> membersToRetain, MemberId coordinator) {
        this.membersToRetain = membersToRetain;
        this.coordinator = coordinator;
    }

    @Override
    public Either<Exception, List<TopologyChangeOperation>> operations(ClusterTopology currentTopology) {
        for (MemberId member : this.membersToRetain) {
            if (currentTopology.hasMember(member)) continue;
            return Either.left((Object)new TopologyRequestFailedException.InvalidRequest(String.format("Expected to force configure while retaining broker '%s', but broker '%s' is not in the current cluster. Current members are '%s'", member, member, currentTopology.members().keySet())));
        }
        List<Integer> partitions = currentTopology.members().values().stream().map(MemberState::partitions).flatMap(p -> p.keySet().stream()).distinct().toList();
        Map<Integer, ArrayList<MemberId>> partitionsWithNewMembers = this.calculateNewConfiguration(currentTopology, this.membersToRetain, partitions);
        List<Integer> partitionsWithNoReplicas = partitions.stream().filter(p -> !partitionsWithNewMembers.containsKey(p) || ((ArrayList)partitionsWithNewMembers.get(p)).isEmpty()).toList();
        boolean hasReplicasForAllPartitions = partitionsWithNoReplicas.isEmpty();
        if (!hasReplicasForAllPartitions) {
            return Either.left((Object)new TopologyRequestFailedException.InvalidRequest(String.format("Expected to force configure and retain members '%s', but this will result in partitions '%s' having no replicas", this.membersToRetain, partitionsWithNoReplicas)));
        }
        List<MemberId> memberToRemove = currentTopology.members().keySet().stream().filter(m -> !this.membersToRetain.contains(m)).toList();
        return this.generateOperations(partitionsWithNewMembers, memberToRemove);
    }

    @Override
    public boolean isForced() {
        return true;
    }

    private Either<Exception, List<TopologyChangeOperation>> generateOperations(Map<Integer, ArrayList<MemberId>> partitionsWithNewMembers, List<MemberId> memberToRemove) {
        List<TopologyChangeOperation> partitionForceConfigureOperations = this.reconfigurePartitions(partitionsWithNewMembers);
        ArrayList<TopologyChangeOperation> operations = new ArrayList<TopologyChangeOperation>(partitionForceConfigureOperations);
        List<TopologyChangeOperation> memberRemoveOperations = this.forceRemoveMembers(memberToRemove);
        operations.addAll(memberRemoveOperations);
        return Either.right(operations);
    }

    private List<TopologyChangeOperation> reconfigurePartitions(Map<Integer, ArrayList<MemberId>> partitionsWithNewMembers) {
        return partitionsWithNewMembers.entrySet().stream().map(partition -> new TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation((MemberId)((ArrayList)partition.getValue()).stream().findFirst().orElseThrow(), (Integer)partition.getKey(), (Collection)partition.getValue())).map(TopologyChangeOperation.class::cast).toList();
    }

    private List<TopologyChangeOperation> forceRemoveMembers(List<MemberId> membersToRemove) {
        return membersToRemove.stream().map(member -> new TopologyChangeOperation.MemberRemoveOperation(this.coordinator, (MemberId)member)).map(TopologyChangeOperation.class::cast).toList();
    }

    private Map<Integer, ArrayList<MemberId>> calculateNewConfiguration(ClusterTopology currentTopology, Set<MemberId> membersToRetain, List<Integer> partitions) {
        HashMap<Integer, ArrayList<MemberId>> partitionToMembersMap = new HashMap<Integer, ArrayList<MemberId>>();
        for (Integer partitionId : partitions) {
            partitionToMembersMap.put(partitionId, new ArrayList());
            for (MemberId member : membersToRetain) {
                if (!currentTopology.getMember(member).hasPartition(partitionId)) continue;
                partitionToMembersMap.computeIfPresent(partitionId, (ignore, members) -> {
                    members.add(member);
                    return members;
                });
            }
        }
        return partitionToMembersMap;
    }
}

