/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.api;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.camunda.zeebe.topology.api.TopologyRequestFailedException;
import io.camunda.zeebe.topology.changes.TopologyChangeCoordinator;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.topology.util.RoundRobinPartitionDistributor;
import io.camunda.zeebe.topology.util.TopologyUtil;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;

public class PartitionReassignRequestTransformer
implements TopologyChangeCoordinator.TopologyChangeRequest {
    final Set<MemberId> members;
    private final Optional<Integer> newReplicationFactor;

    public PartitionReassignRequestTransformer(Set<MemberId> members, Optional<Integer> newReplicationFactor) {
        this.members = members;
        this.newReplicationFactor = newReplicationFactor;
    }

    public PartitionReassignRequestTransformer(Set<MemberId> members) {
        this(members, Optional.empty());
    }

    @Override
    public Either<Exception, List<TopologyChangeOperation>> operations(ClusterTopology currentTopology) {
        if (this.members.isEmpty()) {
            return Either.left((Object)new TopologyRequestFailedException.InvalidRequest(new IllegalArgumentException("Cannot reassign partitions if no brokers are provided")));
        }
        return this.generatePartitionDistributionOperations(currentTopology, this.members);
    }

    private int getReplicationFactor(ClusterTopology clusterTopology) {
        return this.newReplicationFactor.orElse(clusterTopology.minReplicationFactor());
    }

    private Either<Exception, List<TopologyChangeOperation>> generatePartitionDistributionOperations(ClusterTopology currentTopology, Set<MemberId> brokers) {
        ArrayList<TopologyChangeOperation> operations = new ArrayList<TopologyChangeOperation>();
        Set<PartitionMetadata> oldDistribution = TopologyUtil.getPartitionDistributionFrom(currentTopology, "temp");
        int replicationFactor = this.getReplicationFactor(currentTopology);
        if (replicationFactor <= 0) {
            return Either.left((Object)new TopologyRequestFailedException.InvalidRequest(String.format("Replication factor [%d] must be greater than 0", replicationFactor)));
        }
        if (brokers.size() < replicationFactor) {
            return Either.left((Object)new TopologyRequestFailedException.InvalidRequest(String.format("Number of brokers [%d] is less than the replication factor [%d]", brokers.size(), replicationFactor)));
        }
        int partitionCount = currentTopology.partitionCount();
        List<PartitionId> sortedPartitions = IntStream.rangeClosed(1, partitionCount).mapToObj(i -> PartitionId.from((String)"temp", (int)i)).sorted().toList();
        RoundRobinPartitionDistributor roundRobinDistributor = new RoundRobinPartitionDistributor();
        Set<PartitionMetadata> newDistribution = roundRobinDistributor.distributePartitions(brokers, sortedPartitions, replicationFactor);
        for (PartitionMetadata newMetadata : newDistribution) {
            PartitionMetadata oldMetadata = oldDistribution.stream().filter(old -> ((Integer)old.id().id()).equals(newMetadata.id().id())).findFirst().orElseThrow();
            operations.addAll(this.movePartition(oldMetadata, newMetadata));
        }
        return Either.right(operations);
    }

    private List<TopologyChangeOperation> movePartition(PartitionMetadata oldMetadata, PartitionMetadata newMetadata) {
        Integer partitionId = (Integer)newMetadata.id().id();
        ArrayList<TopologyChangeOperation> operations = new ArrayList<TopologyChangeOperation>();
        List<TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation> membersToJoin = newMetadata.members().stream().filter(member -> !oldMetadata.members().contains(member)).map(newMember -> new TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation((MemberId)newMember, partitionId, newMetadata.getPriority(newMember))).toList();
        List<TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation> membersToLeave = oldMetadata.members().stream().filter(member -> !newMetadata.members().contains(member)).map(oldMember -> new TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation((MemberId)oldMember, partitionId)).toList();
        List<TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation> membersToChangePriority = oldMetadata.members().stream().filter(memberId -> newMetadata.members().contains(memberId)).filter(memberId -> newMetadata.getPriority(memberId) != oldMetadata.getPriority(memberId)).map(memberId -> new TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation((MemberId)memberId, partitionId, newMetadata.getPriority(memberId))).toList();
        operations.addAll(membersToJoin);
        operations.addAll(membersToLeave);
        operations.addAll(membersToChangePriority);
        return operations;
    }
}

