/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.api;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.topology.api.AddMembersTransformer;
import io.camunda.zeebe.topology.api.PartitionReassignRequestTransformer;
import io.camunda.zeebe.topology.api.RemoveMembersTransformer;
import io.camunda.zeebe.topology.changes.TopologyChangeCoordinator;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ScaleRequestTransformer
implements TopologyChangeCoordinator.TopologyChangeRequest {
    private final Set<MemberId> members;
    private final Optional<Integer> newReplicationFactor;
    private final ArrayList<TopologyChangeOperation> generatedOperations = new ArrayList();

    public ScaleRequestTransformer(Set<MemberId> members) {
        this(members, Optional.empty());
    }

    public ScaleRequestTransformer(Set<MemberId> members, Optional<Integer> newReplicationFactor) {
        this.members = members;
        this.newReplicationFactor = newReplicationFactor;
    }

    @Override
    public Either<Exception, List<TopologyChangeOperation>> operations(ClusterTopology currentTopology) {
        this.generatedOperations.clear();
        return new AddMembersTransformer(this.members).operations(currentTopology).map(this::addToOperations).flatMap(ignore -> new PartitionReassignRequestTransformer(this.members, this.newReplicationFactor).operations(currentTopology)).map(this::addToOperations).flatMap(ignore -> {
            Set<MemberId> membersToRemove = currentTopology.members().keySet().stream().filter(m -> !this.members.contains(m)).collect(Collectors.toSet());
            return new RemoveMembersTransformer(membersToRemove).operations(currentTopology);
        }).map(this::addToOperations);
    }

    private ArrayList<TopologyChangeOperation> addToOperations(List<TopologyChangeOperation> reassignOperations) {
        this.generatedOperations.addAll(reassignOperations);
        return this.generatedOperations;
    }
}

