/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.api;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.NodeId;
import io.camunda.zeebe.topology.state.ClusterTopology;
import java.util.Collection;
import java.util.function.Supplier;

public interface TopologyCoordinatorSupplier {
    public MemberId getDefaultCoordinator();

    public MemberId getNextCoordinator(Collection<MemberId> var1);

    public static class ClusterTopologyAwareCoordinatorSupplier
    implements TopologyCoordinatorSupplier {
        private final Supplier<ClusterTopology> clusterTopologySupplier;

        public ClusterTopologyAwareCoordinatorSupplier(Supplier<ClusterTopology> clusterTopologySupplier) {
            this.clusterTopologySupplier = clusterTopologySupplier;
        }

        private MemberId lowestMemberId(Collection<MemberId> members) {
            if (members.isEmpty()) {
                return MemberId.from((String)"0");
            }
            return members.stream().min(NodeId::compareTo).orElseThrow();
        }

        @Override
        public MemberId getDefaultCoordinator() {
            ClusterTopology clusterTopology = this.clusterTopologySupplier.get();
            return this.lowestMemberId(clusterTopology.members().keySet());
        }

        @Override
        public MemberId getNextCoordinator(Collection<MemberId> members) {
            return this.lowestMemberId(members);
        }
    }
}

