/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.api;

import io.atomix.cluster.MemberId;
import java.util.Optional;
import java.util.Set;

public sealed interface TopologyManagementRequest {
    public boolean dryRun();

    public record CancelChangeRequest(long changeId) implements TopologyManagementRequest
    {
        @Override
        public boolean dryRun() {
            return false;
        }
    }

    public record ScaleRequest(Set<MemberId> members, Optional<Integer> newReplicationFactor, boolean dryRun) implements TopologyManagementRequest
    {
        public ScaleRequest(Set<MemberId> members, boolean dryRun) {
            this(members, Optional.empty(), dryRun);
        }
    }

    public record ReassignPartitionsRequest(Set<MemberId> members, boolean dryRun) implements TopologyManagementRequest
    {
    }

    public record LeavePartitionRequest(MemberId memberId, int partitionId, boolean dryRun) implements TopologyManagementRequest
    {
    }

    public record JoinPartitionRequest(MemberId memberId, int partitionId, int priority, boolean dryRun) implements TopologyManagementRequest
    {
    }

    public record RemoveMembersRequest(Set<MemberId> members, boolean dryRun) implements TopologyManagementRequest
    {
    }

    public record AddMembersRequest(Set<MemberId> members, boolean dryRun) implements TopologyManagementRequest
    {
    }
}

