/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.api;

import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.topology.api.ErrorResponse;
import io.camunda.zeebe.topology.api.TopologyChangeResponse;
import io.camunda.zeebe.topology.api.TopologyCoordinatorSupplier;
import io.camunda.zeebe.topology.api.TopologyManagementRequest;
import io.camunda.zeebe.topology.api.TopologyRequestTopics;
import io.camunda.zeebe.topology.serializer.TopologyRequestsSerializer;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.util.Either;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class TopologyManagementRequestSender {
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private final ClusterCommunicationService communicationService;
    private final TopologyCoordinatorSupplier coordinatorSupplier;
    private final TopologyRequestsSerializer serializer;

    public TopologyManagementRequestSender(ClusterCommunicationService communicationService, TopologyCoordinatorSupplier coordinatorSupplier, TopologyRequestsSerializer serializer) {
        this.communicationService = communicationService;
        this.coordinatorSupplier = coordinatorSupplier;
        this.serializer = serializer;
    }

    public CompletableFuture<Either<ErrorResponse, TopologyChangeResponse>> addMembers(TopologyManagementRequest.AddMembersRequest addMembersRequest) {
        return this.communicationService.send(TopologyRequestTopics.ADD_MEMBER.topic(), (Object)addMembersRequest, this.serializer::encodeAddMembersRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, TopologyChangeResponse>> removeMembers(TopologyManagementRequest.RemoveMembersRequest removeMembersRequest) {
        return this.communicationService.send(TopologyRequestTopics.REMOVE_MEMBER.topic(), (Object)removeMembersRequest, this.serializer::encodeRemoveMembersRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, TopologyChangeResponse>> joinPartition(TopologyManagementRequest.JoinPartitionRequest joinPartitionRequest) {
        return this.communicationService.send(TopologyRequestTopics.JOIN_PARTITION.topic(), (Object)joinPartitionRequest, this.serializer::encodeJoinPartitionRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, TopologyChangeResponse>> leavePartition(TopologyManagementRequest.LeavePartitionRequest leavePartitionRequest) {
        return this.communicationService.send(TopologyRequestTopics.LEAVE_PARTITION.topic(), (Object)leavePartitionRequest, this.serializer::encodeLeavePartitionRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, TopologyChangeResponse>> reassignPartitions(TopologyManagementRequest.ReassignPartitionsRequest reassignPartitionsRequest) {
        return this.communicationService.send(TopologyRequestTopics.REASSIGN_PARTITIONS.topic(), (Object)reassignPartitionsRequest, this.serializer::encodeReassignPartitionsRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, TopologyChangeResponse>> scaleMembers(TopologyManagementRequest.ScaleRequest scaleRequest) {
        return this.communicationService.send(TopologyRequestTopics.SCALE_MEMBERS.topic(), (Object)scaleRequest, this.serializer::encodeScaleRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, TopologyChangeResponse>> forceScaleDown(TopologyManagementRequest.ScaleRequest forceScaleDownRequest) {
        return this.communicationService.send(TopologyRequestTopics.FORCE_SCALE_DOWN.topic(), (Object)forceScaleDownRequest, this.serializer::encodeScaleRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getNextCoordinator(forceScaleDownRequest.members()), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterTopology>> getTopology() {
        return this.communicationService.send(TopologyRequestTopics.QUERY_TOPOLOGY.topic(), (Object)new byte[0], Function.identity(), this.serializer::decodeClusterTopologyResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterTopology>> cancelTopologyChange(TopologyManagementRequest.CancelChangeRequest request) {
        return this.communicationService.send(TopologyRequestTopics.CANCEL_CHANGE.topic(), (Object)request, this.serializer::encodeCancelChangeRequest, this.serializer::decodeClusterTopologyResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }
}

