/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.api;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.topology.api.AddMembersTransformer;
import io.camunda.zeebe.topology.api.ForceScaleDownRequestTransformer;
import io.camunda.zeebe.topology.api.PartitionReassignRequestTransformer;
import io.camunda.zeebe.topology.api.RemoveMembersTransformer;
import io.camunda.zeebe.topology.api.ScaleRequestTransformer;
import io.camunda.zeebe.topology.api.TopologyChangeResponse;
import io.camunda.zeebe.topology.api.TopologyManagementApi;
import io.camunda.zeebe.topology.api.TopologyManagementRequest;
import io.camunda.zeebe.topology.api.TopologyRequestFailedException;
import io.camunda.zeebe.topology.changes.TopologyChangeCoordinator;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public final class TopologyManagementRequestsHandler
implements TopologyManagementApi {
    private final TopologyChangeCoordinator coordinator;
    private final ConcurrencyControl executor;
    private final MemberId localMemberId;

    public TopologyManagementRequestsHandler(TopologyChangeCoordinator coordinator, MemberId localMemberId, ConcurrencyControl executor) {
        this.coordinator = coordinator;
        this.executor = executor;
        this.localMemberId = localMemberId;
    }

    @Override
    public ActorFuture<TopologyChangeResponse> addMembers(TopologyManagementRequest.AddMembersRequest addMembersRequest) {
        return this.handleRequest(addMembersRequest.dryRun(), new AddMembersTransformer(addMembersRequest.members()));
    }

    @Override
    public ActorFuture<TopologyChangeResponse> removeMembers(TopologyManagementRequest.RemoveMembersRequest removeMembersRequest) {
        return this.handleRequest(removeMembersRequest.dryRun(), new RemoveMembersTransformer(removeMembersRequest.members()));
    }

    @Override
    public ActorFuture<TopologyChangeResponse> joinPartition(TopologyManagementRequest.JoinPartitionRequest joinPartitionRequest) {
        return this.handleRequest(joinPartitionRequest.dryRun(), ignore -> Either.right(List.of(new TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation(joinPartitionRequest.memberId(), joinPartitionRequest.partitionId(), joinPartitionRequest.priority()))));
    }

    @Override
    public ActorFuture<TopologyChangeResponse> leavePartition(TopologyManagementRequest.LeavePartitionRequest leavePartitionRequest) {
        return this.handleRequest(leavePartitionRequest.dryRun(), ignore -> Either.right(List.of(new TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation(leavePartitionRequest.memberId(), leavePartitionRequest.partitionId()))));
    }

    @Override
    public ActorFuture<TopologyChangeResponse> reassignPartitions(TopologyManagementRequest.ReassignPartitionsRequest reassignPartitionsRequest) {
        return this.handleRequest(reassignPartitionsRequest.dryRun(), new PartitionReassignRequestTransformer(reassignPartitionsRequest.members()));
    }

    @Override
    public ActorFuture<TopologyChangeResponse> scaleMembers(TopologyManagementRequest.ScaleRequest scaleRequest) {
        return this.handleRequest(scaleRequest.dryRun(), new ScaleRequestTransformer(scaleRequest.members(), scaleRequest.newReplicationFactor()));
    }

    @Override
    public ActorFuture<TopologyChangeResponse> forceScaleDown(TopologyManagementRequest.ScaleRequest forceScaleDownRequest) {
        Optional<Integer> optionalNewReplicationFactor = forceScaleDownRequest.newReplicationFactor();
        if (optionalNewReplicationFactor.isPresent()) {
            ActorFuture failedFuture = this.executor.createFuture();
            String errorMessage = String.format("The replication factor cannot be changed to requested value '%s' during force scale down. It will be automatically changed based on which brokers are removed. Do not provide any replication factor in the request", optionalNewReplicationFactor.get());
            failedFuture.completeExceptionally((Throwable)new TopologyRequestFailedException.InvalidRequest(errorMessage));
            return failedFuture;
        }
        return this.handleRequest(forceScaleDownRequest.dryRun(), new ForceScaleDownRequestTransformer(forceScaleDownRequest.members(), this.localMemberId));
    }

    @Override
    public ActorFuture<ClusterTopology> cancelTopologyChange(TopologyManagementRequest.CancelChangeRequest changeRequest) {
        return this.coordinator.cancelChange(changeRequest.changeId());
    }

    @Override
    public ActorFuture<ClusterTopology> getTopology() {
        return this.coordinator.getTopology();
    }

    private ActorFuture<TopologyChangeResponse> handleRequest(boolean dryRun, TopologyChangeCoordinator.TopologyChangeRequest request) {
        ActorFuture responseFuture = this.executor.createFuture();
        Function<TopologyChangeCoordinator.TopologyChangeRequest, ActorFuture> handler = dryRun ? this.coordinator::simulateOperations : this.coordinator::applyOperations;
        this.executor.run(() -> ((ActorFuture)handler.apply(request)).onComplete((result, error) -> {
            if (error == null) {
                TopologyChangeResponse changeStatus = new TopologyChangeResponse(result.changeId(), result.currentTopology().members(), result.finalTopology().members(), result.operations());
                responseFuture.complete((Object)changeStatus);
            } else {
                responseFuture.completeExceptionally(error);
            }
        }));
        return responseFuture;
    }
}

