/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.api;

import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.topology.api.ErrorResponse;
import io.camunda.zeebe.topology.api.TopologyChangeResponse;
import io.camunda.zeebe.topology.api.TopologyManagementApi;
import io.camunda.zeebe.topology.api.TopologyManagementRequest;
import io.camunda.zeebe.topology.api.TopologyRequestFailedException;
import io.camunda.zeebe.topology.api.TopologyRequestTopics;
import io.camunda.zeebe.topology.serializer.TopologyRequestsSerializer;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;

public final class TopologyRequestServer
implements AutoCloseable {
    private final TopologyManagementApi topologyManagementApi;
    private final ClusterCommunicationService communicationService;
    private final TopologyRequestsSerializer serializer;

    public TopologyRequestServer(ClusterCommunicationService communicationService, TopologyRequestsSerializer serializer, TopologyManagementApi topologyManagementApi) {
        this.topologyManagementApi = topologyManagementApi;
        this.communicationService = communicationService;
        this.serializer = serializer;
    }

    public void start() {
        this.registerAddMemberRequestsHandler();
        this.registerRemoveMemberRequestsHandler();
        this.registerJoinPartitionRequestsHandler();
        this.registerLeavePartitionRequestsHandler();
        this.registerReassignPartitionRequestHandler();
        this.registerScaleRequestHandler();
        this.registerGetTopologyQueryHandler();
        this.registerTopologyCancelHandler();
        this.registerForceScaleDownHandler();
    }

    @Override
    public void close() {
        Stream.of(TopologyRequestTopics.values()).toList().forEach(topic -> this.communicationService.unsubscribe(topic.topic()));
    }

    private void registerAddMemberRequestsHandler() {
        this.communicationService.replyTo(TopologyRequestTopics.ADD_MEMBER.topic(), this.serializer::decodeAddMembersRequest, request -> this.mapResponse(this.topologyManagementApi.addMembers((TopologyManagementRequest.AddMembersRequest)request)), this::encodeResponse);
    }

    byte[] encodeResponse(Either<ErrorResponse, TopologyChangeResponse> response) {
        if (response.isLeft()) {
            return this.serializer.encodeResponse((ErrorResponse)response.getLeft());
        }
        return this.serializer.encodeResponse((TopologyChangeResponse)response.get());
    }

    byte[] encodeClusterTopologyResponse(Either<ErrorResponse, ClusterTopology> response) {
        if (response.isLeft()) {
            return this.serializer.encodeResponse((ErrorResponse)response.getLeft());
        }
        return this.serializer.encodeResponse((ClusterTopology)response.get());
    }

    private void registerRemoveMemberRequestsHandler() {
        this.communicationService.replyTo(TopologyRequestTopics.REMOVE_MEMBER.topic(), this.serializer::decodeRemoveMembersRequest, request -> this.mapResponse(this.topologyManagementApi.removeMembers((TopologyManagementRequest.RemoveMembersRequest)request)), this::encodeResponse);
    }

    private void registerJoinPartitionRequestsHandler() {
        this.communicationService.replyTo(TopologyRequestTopics.JOIN_PARTITION.topic(), this.serializer::decodeJoinPartitionRequest, request -> this.mapResponse(this.topologyManagementApi.joinPartition((TopologyManagementRequest.JoinPartitionRequest)request)), this::encodeResponse);
    }

    private void registerLeavePartitionRequestsHandler() {
        this.communicationService.replyTo(TopologyRequestTopics.LEAVE_PARTITION.topic(), this.serializer::decodeLeavePartitionRequest, request -> this.mapResponse(this.topologyManagementApi.leavePartition((TopologyManagementRequest.LeavePartitionRequest)request)), this::encodeResponse);
    }

    private void registerReassignPartitionRequestHandler() {
        this.communicationService.replyTo(TopologyRequestTopics.REASSIGN_PARTITIONS.topic(), this.serializer::decodeReassignPartitionsRequest, request -> this.mapResponse(this.topologyManagementApi.reassignPartitions((TopologyManagementRequest.ReassignPartitionsRequest)request)), this::encodeResponse);
    }

    private void registerScaleRequestHandler() {
        this.communicationService.replyTo(TopologyRequestTopics.SCALE_MEMBERS.topic(), this.serializer::decodeScaleRequest, request -> this.mapResponse(this.topologyManagementApi.scaleMembers((TopologyManagementRequest.ScaleRequest)request)), this::encodeResponse);
    }

    private void registerForceScaleDownHandler() {
        this.communicationService.replyTo(TopologyRequestTopics.FORCE_SCALE_DOWN.topic(), this.serializer::decodeScaleRequest, request -> this.mapResponse(this.topologyManagementApi.forceScaleDown((TopologyManagementRequest.ScaleRequest)request)), this::encodeResponse);
    }

    private void registerGetTopologyQueryHandler() {
        this.communicationService.replyTo(TopologyRequestTopics.QUERY_TOPOLOGY.topic(), Function.identity(), request -> this.mapClusterTopologyResponse(this.topologyManagementApi.getTopology()), this::encodeClusterTopologyResponse);
    }

    private void registerTopologyCancelHandler() {
        this.communicationService.replyTo(TopologyRequestTopics.CANCEL_CHANGE.topic(), this.serializer::decodeCancelChangeRequest, request -> this.mapClusterTopologyResponse(this.topologyManagementApi.cancelTopologyChange((TopologyManagementRequest.CancelChangeRequest)request)), this::encodeClusterTopologyResponse);
    }

    private CompletableFuture<Either<ErrorResponse, TopologyChangeResponse>> mapResponse(ActorFuture<TopologyChangeResponse> topologyManagementApi) {
        return ((CompletableFuture)topologyManagementApi.toCompletableFuture().thenApply(Either::right)).exceptionally(TopologyRequestServer::mapError);
    }

    private CompletableFuture<Either<ErrorResponse, ClusterTopology>> mapClusterTopologyResponse(ActorFuture<ClusterTopology> topologyManagementApi) {
        return ((CompletableFuture)topologyManagementApi.toCompletableFuture().thenApply(Either::right)).exceptionally(TopologyRequestServer::mapError);
    }

    private static <T> Either<ErrorResponse, T> mapError(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        Objects.requireNonNull(throwable2);
        Throwable throwable3 = throwable2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TopologyRequestFailedException.OperationNotAllowed.class, TopologyRequestFailedException.InvalidRequest.class, TopologyRequestFailedException.ConcurrentModificationException.class}, (Object)throwable3, n)) {
            case 0 -> {
                TopologyRequestFailedException.OperationNotAllowed operationNotAllowed = (TopologyRequestFailedException.OperationNotAllowed)throwable3;
                yield Either.left((Object)new ErrorResponse(ErrorResponse.ErrorCode.OPERATION_NOT_ALLOWED, operationNotAllowed.getMessage()));
            }
            case 1 -> {
                TopologyRequestFailedException.InvalidRequest invalidRequest = (TopologyRequestFailedException.InvalidRequest)throwable3;
                yield Either.left((Object)new ErrorResponse(ErrorResponse.ErrorCode.INVALID_REQUEST, invalidRequest.getMessage()));
            }
            case 2 -> {
                TopologyRequestFailedException.ConcurrentModificationException concurrentModificationException = (TopologyRequestFailedException.ConcurrentModificationException)throwable3;
                yield Either.left((Object)new ErrorResponse(ErrorResponse.ErrorCode.CONCURRENT_MODIFICATION, concurrentModificationException.getMessage()));
            }
            default -> Either.left((Object)new ErrorResponse(ErrorResponse.ErrorCode.INTERNAL_ERROR, throwable.getMessage()));
        };
    }
}

