/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.changes.TopologyChangeAppliers;
import io.camunda.zeebe.topology.changes.TopologyMembershipChangeExecutor;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

public class MemberLeaveApplier
implements TopologyChangeAppliers.MemberOperationApplier {
    private final MemberId memberId;
    private final TopologyMembershipChangeExecutor topologyMembershipChangeExecutor;

    public MemberLeaveApplier(MemberId memberId, TopologyMembershipChangeExecutor topologyMembershipChangeExecutor) {
        this.memberId = memberId;
        this.topologyMembershipChangeExecutor = topologyMembershipChangeExecutor;
    }

    @Override
    public MemberId memberId() {
        return this.memberId;
    }

    @Override
    public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterTopology currentClusterTopology) {
        boolean hasPartitions;
        if (!currentClusterTopology.hasMember(this.memberId)) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to remove member %s, but the member is not part of the topology", this.memberId)));
        }
        boolean bl = hasPartitions = !currentClusterTopology.getMember(this.memberId).partitions().isEmpty();
        if (hasPartitions) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to remove member %s, but the member still has partitions assigned. Partitions: [%s]", this.memberId, currentClusterTopology.getMember(this.memberId).partitions())));
        }
        return Either.right(MemberState::toLeaving);
    }

    @Override
    public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
        CompletableActorFuture future = new CompletableActorFuture();
        this.topologyMembershipChangeExecutor.removeBroker(this.memberId).onComplete((ignore, error) -> {
            if (error == null) {
                future.complete(MemberState::toLeft);
            } else {
                future.completeExceptionally(error);
            }
        });
        return future;
    }
}

