/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.changes.TopologyChangeAppliers;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

public class NoopTopologyChangeAppliers
implements TopologyChangeAppliers {
    @Override
    public TopologyChangeAppliers.MemberOperationApplier getApplier(TopologyChangeOperation operation) {
        return new NoopApplier(operation.memberId());
    }

    public static class NoopApplier
    implements TopologyChangeAppliers.MemberOperationApplier {
        private final MemberId memberId;

        public NoopApplier(MemberId memberId) {
            this.memberId = memberId;
        }

        @Override
        public MemberId memberId() {
            return this.memberId;
        }

        @Override
        public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterTopology currentClusterTopology) {
            return Either.right(memberState -> memberState);
        }

        @Override
        public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
            return CompletableActorFuture.completed(memberState -> memberState);
        }
    }
}

