/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.changes.PartitionChangeExecutor;
import io.camunda.zeebe.topology.changes.TopologyChangeAppliers;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.PartitionState;
import io.camunda.zeebe.util.Either;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;

final class PartitionJoinApplier
implements TopologyChangeAppliers.MemberOperationApplier {
    private final int partitionId;
    private final int priority;
    private final PartitionChangeExecutor partitionChangeExecutor;
    private final MemberId localMemberId;
    private Map<MemberId, Integer> partitionMembersWithPriority;

    PartitionJoinApplier(int partitionId, int priority, MemberId localMemberId, PartitionChangeExecutor partitionChangeExecutor) {
        this.partitionId = partitionId;
        this.priority = priority;
        this.localMemberId = localMemberId;
        this.partitionChangeExecutor = partitionChangeExecutor;
    }

    @Override
    public MemberId memberId() {
        return this.localMemberId;
    }

    @Override
    public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterTopology currentClusterTopology) {
        boolean localMemberIsActive;
        boolean bl = localMemberIsActive = currentClusterTopology.hasMember(this.localMemberId) && currentClusterTopology.getMember(this.localMemberId).state() == MemberState.State.ACTIVE;
        if (!localMemberIsActive) {
            return Either.left((Object)new IllegalStateException("Expected to join partition, but the local member is not active"));
        }
        boolean partitionHasActiveMember = currentClusterTopology.members().values().stream().flatMap(memberState -> memberState.partitions().entrySet().stream().filter(partitionState -> (Integer)partitionState.getKey() == this.partitionId).map(Map.Entry::getValue)).anyMatch(partitionState -> partitionState.state() == PartitionState.State.ACTIVE);
        if (!partitionHasActiveMember) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to join partition %s, but partition has no active members", this.partitionId)));
        }
        MemberState localMemberState = currentClusterTopology.getMember(this.localMemberId);
        boolean partitionExistsInLocalMember = localMemberState.hasPartition(this.partitionId);
        if (partitionExistsInLocalMember && localMemberState.getPartition(this.partitionId).state() != PartitionState.State.JOINING) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to join partition %s, but the local member already has the partition at state %s", new Object[]{this.partitionId, localMemberState.partitions().get(this.partitionId).state()})));
        }
        this.partitionMembersWithPriority = this.collectPriorityByMembers(currentClusterTopology);
        if (partitionExistsInLocalMember && localMemberState.getPartition(this.partitionId).state() == PartitionState.State.JOINING) {
            return Either.right(memberState -> memberState);
        }
        return Either.right(memberState -> memberState.addPartition(this.partitionId, PartitionState.joining(this.priority)));
    }

    @Override
    public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
        CompletableActorFuture result = new CompletableActorFuture();
        this.partitionChangeExecutor.join(this.partitionId, this.partitionMembersWithPriority).onComplete((ignore, error) -> {
            if (error == null) {
                result.complete(memberState -> memberState.updatePartition(this.partitionId, PartitionState::toActive));
            } else {
                result.completeExceptionally(error);
            }
        });
        return result;
    }

    private HashMap<MemberId, Integer> collectPriorityByMembers(ClusterTopology currentClusterTopology) {
        HashMap<MemberId, Integer> priorityMap = new HashMap<MemberId, Integer>();
        currentClusterTopology.members().forEach((memberId, memberState) -> {
            if (memberState.partitions().containsKey(this.partitionId)) {
                PartitionState partitionState = memberState.partitions().get(this.partitionId);
                priorityMap.put((MemberId)memberId, partitionState.priority());
            }
        });
        priorityMap.put(this.localMemberId, this.priority);
        return priorityMap;
    }
}

