/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.changes.PartitionChangeExecutor;
import io.camunda.zeebe.topology.changes.TopologyChangeAppliers;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.PartitionState;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

public class PartitionReconfigurePriorityApplier
implements TopologyChangeAppliers.MemberOperationApplier {
    private final int partitionId;
    private final int newPriority;
    private final MemberId localMemberId;
    private final PartitionChangeExecutor partitionChangeExecutor;

    public PartitionReconfigurePriorityApplier(int partitionId, int priority, MemberId memberId, PartitionChangeExecutor partitionChangeExecutor) {
        this.partitionId = partitionId;
        this.newPriority = priority;
        this.localMemberId = memberId;
        this.partitionChangeExecutor = partitionChangeExecutor;
    }

    @Override
    public MemberId memberId() {
        return this.localMemberId;
    }

    @Override
    public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterTopology currentClusterTopology) {
        boolean localMemberIsActive;
        boolean bl = localMemberIsActive = currentClusterTopology.hasMember(this.localMemberId) && currentClusterTopology.getMember(this.localMemberId).state() == MemberState.State.ACTIVE;
        if (!localMemberIsActive) {
            return Either.left((Object)new IllegalStateException("Expected to change priority of a partition, but the local member is not active"));
        }
        MemberState localMemberState = currentClusterTopology.getMember(this.localMemberId);
        boolean partitionExistsInLocalMember = localMemberState.hasPartition(this.partitionId);
        if (!partitionExistsInLocalMember) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to change priority of partition %d, but the local member does not have the partition", this.partitionId)));
        }
        PartitionState.State partitionState = localMemberState.getPartition(this.partitionId).state();
        if (partitionState != PartitionState.State.ACTIVE) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to change priority of partition %d, but the local member has partition in state %s", new Object[]{this.partitionId, partitionState})));
        }
        return Either.right(memberState -> memberState);
    }

    @Override
    public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
        CompletableActorFuture result = new CompletableActorFuture();
        this.partitionChangeExecutor.reconfigurePriority(this.partitionId, this.newPriority).onComplete((ignore, error) -> {
            if (error == null) {
                result.complete(memberState -> memberState.updatePartition(this.partitionId, partitionState -> new PartitionState(partitionState.state(), this.newPriority)));
            } else {
                result.completeExceptionally(error);
            }
        });
        return result;
    }
}

