/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

@FunctionalInterface
public interface TopologyChangeAppliers {
    public ClusterOperationApplier getApplier(TopologyChangeOperation var1);

    public static interface MemberOperationApplier
    extends ClusterOperationApplier {
        @Override
        default public Either<Exception, UnaryOperator<ClusterTopology>> init(ClusterTopology currentClusterTopology) {
            return this.initMemberState(currentClusterTopology).map(transformer -> cluster -> cluster.updateMember(this.memberId(), (UnaryOperator<MemberState>)transformer));
        }

        @Override
        default public ActorFuture<UnaryOperator<ClusterTopology>> apply() {
            CompletableActorFuture future = new CompletableActorFuture();
            this.applyOperation().onComplete((transformer, error) -> {
                if (error == null) {
                    future.complete(cluster -> cluster.updateMember(this.memberId(), (UnaryOperator<MemberState>)transformer));
                } else {
                    future.completeExceptionally(error);
                }
            });
            return future;
        }

        public MemberId memberId();

        public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterTopology var1);

        public ActorFuture<UnaryOperator<MemberState>> applyOperation();
    }

    public static interface ClusterOperationApplier {
        public Either<Exception, UnaryOperator<ClusterTopology>> init(ClusterTopology var1);

        public ActorFuture<UnaryOperator<ClusterTopology>> apply();
    }
}

