/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.changes.MemberJoinApplier;
import io.camunda.zeebe.topology.changes.MemberLeaveApplier;
import io.camunda.zeebe.topology.changes.PartitionChangeExecutor;
import io.camunda.zeebe.topology.changes.PartitionForceReconfigureApplier;
import io.camunda.zeebe.topology.changes.PartitionJoinApplier;
import io.camunda.zeebe.topology.changes.PartitionLeaveApplier;
import io.camunda.zeebe.topology.changes.PartitionReconfigurePriorityApplier;
import io.camunda.zeebe.topology.changes.TopologyChangeAppliers;
import io.camunda.zeebe.topology.changes.TopologyMembershipChangeExecutor;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.function.UnaryOperator;

public class TopologyChangeAppliersImpl
implements TopologyChangeAppliers {
    private final PartitionChangeExecutor partitionChangeExecutor;
    private final TopologyMembershipChangeExecutor topologyMembershipChangeExecutor;

    public TopologyChangeAppliersImpl(PartitionChangeExecutor partitionChangeExecutor, TopologyMembershipChangeExecutor topologyMembershipChangeExecutor) {
        this.partitionChangeExecutor = partitionChangeExecutor;
        this.topologyMembershipChangeExecutor = topologyMembershipChangeExecutor;
    }

    @Override
    public TopologyChangeAppliers.ClusterOperationApplier getApplier(TopologyChangeOperation operation) {
        TopologyChangeOperation topologyChangeOperation = operation;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation.class, TopologyChangeOperation.MemberJoinOperation.class, TopologyChangeOperation.MemberLeaveOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation.class, TopologyChangeOperation.MemberRemoveOperation.class}, (Object)topologyChangeOperation, n)) {
            case 0 -> {
                TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation joinOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation)topologyChangeOperation;
                yield new PartitionJoinApplier(joinOperation.partitionId(), joinOperation.priority(), joinOperation.memberId(), this.partitionChangeExecutor);
            }
            case 1 -> {
                TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation leaveOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation)topologyChangeOperation;
                yield new PartitionLeaveApplier(leaveOperation.partitionId(), leaveOperation.memberId(), this.partitionChangeExecutor);
            }
            case 2 -> {
                TopologyChangeOperation.MemberJoinOperation memberJoinOperation = (TopologyChangeOperation.MemberJoinOperation)topologyChangeOperation;
                yield new MemberJoinApplier(memberJoinOperation.memberId(), this.topologyMembershipChangeExecutor);
            }
            case 3 -> {
                TopologyChangeOperation.MemberLeaveOperation memberLeaveOperation = (TopologyChangeOperation.MemberLeaveOperation)topologyChangeOperation;
                yield new MemberLeaveApplier(memberLeaveOperation.memberId(), this.topologyMembershipChangeExecutor);
            }
            case 4 -> {
                TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation reconfigurePriorityOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation)topologyChangeOperation;
                yield new PartitionReconfigurePriorityApplier(reconfigurePriorityOperation.partitionId(), reconfigurePriorityOperation.priority(), reconfigurePriorityOperation.memberId(), this.partitionChangeExecutor);
            }
            case 5 -> {
                TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation forceReconfigureOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation)topologyChangeOperation;
                yield new PartitionForceReconfigureApplier(forceReconfigureOperation.partitionId(), forceReconfigureOperation.memberId(), forceReconfigureOperation.members(), this.partitionChangeExecutor);
            }
            case 6 -> {
                TopologyChangeOperation.MemberRemoveOperation memberRemoveOperation = (TopologyChangeOperation.MemberRemoveOperation)topologyChangeOperation;
                yield new MemberLeaveApplier(memberRemoveOperation.memberToRemove(), this.topologyMembershipChangeExecutor);
            }
            default -> new FailingApplier(operation);
        };
    }

    static class FailingApplier
    implements TopologyChangeAppliers.MemberOperationApplier {
        private final TopologyChangeOperation operation;

        public FailingApplier(TopologyChangeOperation operation) {
            this.operation = operation;
        }

        @Override
        public MemberId memberId() {
            return this.operation.memberId();
        }

        @Override
        public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterTopology currentClusterTopology) {
            return Either.left((Object)new UnknownOperationException(this.operation));
        }

        @Override
        public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
            return CompletableActorFuture.completedExceptionally((Throwable)new UnknownOperationException(this.operation));
        }

        private static class UnknownOperationException
        extends RuntimeException {
            public UnknownOperationException(TopologyChangeOperation operation) {
                super("Unknown topology change operation " + String.valueOf(operation));
            }
        }
    }
}

