/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.metrics;

import io.camunda.zeebe.topology.metrics.TopologyManagerMetricsDoc;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.collection.Table;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.Map;

public class TopologyManagerMetrics {
    private final Map<String, Timer> operationDuration;
    private final Table<String, String, Counter> operationAttempts;
    private final MeterRegistry registry;

    public TopologyManagerMetrics(MeterRegistry registry) {
        this.registry = registry;
        this.operationDuration = new HashMap<String, Timer>();
        this.operationAttempts = Table.simple();
    }

    public OperationObserver observeOperation(TopologyChangeOperation operation) {
        return this.startOperation(operation);
    }

    OperationObserver startOperation(TopologyChangeOperation operation) {
        Timer timer = this.operationDuration.computeIfAbsent(operation.getClass().getSimpleName(), this::registerOperation);
        return new OperationObserver(operation, MicrometerUtil.timer((Timer)timer, (Timer.Sample)Timer.start((MeterRegistry)this.registry)));
    }

    private Timer registerOperation(String operation) {
        return Timer.builder((String)TopologyManagerMetricsDoc.OPERATION_DURATION.getName()).description(TopologyManagerMetricsDoc.OPERATION_DURATION.getDescription()).serviceLevelObjectives(TopologyManagerMetricsDoc.OPERATION_DURATION.getTimerSLOs()).tags(new String[]{TopologyManagerMetricsDoc.TopologyManagerMetricsKeyName.OPERATION.asString(), operation}).register(this.registry);
    }

    private Counter registerAttempt(String operation, String outcome) {
        return Counter.builder((String)TopologyManagerMetricsDoc.OPERATION_ATTEMPTS.getName()).description(TopologyManagerMetricsDoc.OPERATION_DURATION.getDescription()).tags(new String[]{TopologyManagerMetricsDoc.TopologyManagerMetricsKeyName.OPERATION.asString(), operation, TopologyManagerMetricsDoc.TopologyManagerMetricsKeyName.OUTCOME.asString(), outcome}).register(this.registry);
    }

    public final class OperationObserver {
        private final TopologyChangeOperation operation;
        private final CloseableSilently timer;

        private OperationObserver(TopologyChangeOperation operation, CloseableSilently timer) {
            this.operation = operation;
            this.timer = timer;
        }

        public void failed() {
            this.timer.close();
            ((Counter)TopologyManagerMetrics.this.operationAttempts.computeIfAbsent((Object)this.operation.getClass().getSimpleName(), (Object)TopologyManagerMetricsDoc.Outcome.FAILED.getName(), TopologyManagerMetrics.this::registerAttempt)).increment();
        }

        public void applied() {
            this.timer.close();
            ((Counter)TopologyManagerMetrics.this.operationAttempts.computeIfAbsent((Object)this.operation.getClass().getSimpleName(), (Object)TopologyManagerMetricsDoc.Outcome.APPLIED.getName(), TopologyManagerMetrics.this::registerAttempt)).increment();
        }
    }
}

