/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.metrics;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import java.time.Duration;
import java.util.stream.Stream;

public enum TopologyManagerMetricsDoc implements ExtendedMeterDocumentation
{
    OPERATION_DURATION{
        private static final Duration[] TIMER_SLOS = (Duration[])Stream.of(100, 1000, 2000, 5000, 10000, 30000, 60000, 120000, 180000, 300000, 600000).map(Duration::ofMillis).toArray(Duration[]::new);

        public String getName() {
            return "zeebe.cluster.changes.operation.duration";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Duration it takes to apply an operation";
        }

        public Duration[] getTimerSLOs() {
            return TIMER_SLOS;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{TopologyManagerMetricsKeyName.OPERATION};
        }
    }
    ,
    OPERATION_ATTEMPTS{

        public String getName() {
            return "zeebe.cluster.changes.operation.attempts";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public String getDescription() {
            return "Number of attempts per operation type";
        }

        public KeyName[] getKeyNames() {
            return TopologyManagerMetricsKeyName.values();
        }
    };


    public static enum Outcome {
        FAILED("failed"),
        APPLIED("applied");

        private final String name;

        private Outcome(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum TopologyManagerMetricsKeyName implements KeyName
    {
        OPERATION{

            public String asString() {
                return "operation";
            }
        }
        ,
        OUTCOME{

            public String asString() {
                return "outcome";
            }
        };

    }
}

