/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.metrics;

import io.camunda.zeebe.topology.metrics.TopologyMetricsDoc;
import io.camunda.zeebe.topology.state.ClusterChangePlan;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.CompletedChange;
import io.camunda.zeebe.util.micrometer.EnumMeter;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public final class TopologyMetrics {
    private final MeterRegistry registry;
    private final AtomicLong topologyVersion;
    private final AtomicLong changeId;
    private final AtomicLong changeVersion;
    private final AtomicLong pendingOperations;
    private final AtomicLong completedOperations;
    private final EnumMeter<ClusterChangePlan.Status> changeStatus;

    public TopologyMetrics(MeterRegistry registry) {
        this.registry = registry;
        this.topologyVersion = this.makeGauge(TopologyMetricsDoc.TOPOLOGY_VERSION);
        this.changeId = this.makeGauge(TopologyMetricsDoc.CHANGE_ID);
        this.changeStatus = EnumMeter.register(ClusterChangePlan.Status.class, (ExtendedMeterDocumentation)TopologyMetricsDoc.CHANGE_STATUS, (KeyName)TopologyMetricsDoc.TopologyMetricsKeyName.CLUSTER_CHANGE_STATUS, (MeterRegistry)registry);
        this.changeVersion = this.makeGauge(TopologyMetricsDoc.CHANGE_VERSION);
        this.pendingOperations = this.makeGauge(TopologyMetricsDoc.PENDING_OPERATIONS);
        this.completedOperations = this.makeGauge(TopologyMetricsDoc.COMPLETED_OPERATIONS);
    }

    private AtomicLong makeGauge(TopologyMetricsDoc meter) {
        AtomicLong value = new AtomicLong();
        Gauge.builder((String)meter.getName(), value::get).description(meter.getDescription()).register(this.registry);
        return value;
    }

    public void updateFromTopology(ClusterTopology topology) {
        this.topologyVersion.set(topology.version());
        this.changeStatus.state((Enum)topology.pendingChanges().map(ClusterChangePlan::status).or(() -> topology.lastChange().map(CompletedChange::status)).orElse(ClusterChangePlan.Status.COMPLETED));
        this.changeId.set(topology.pendingChanges().map(ClusterChangePlan::id).orElse(0L));
        this.changeVersion.set(topology.pendingChanges().map(ClusterChangePlan::version).orElse(0).intValue());
        this.pendingOperations.set(topology.pendingChanges().map(ClusterChangePlan::pendingOperations).map(List::size).orElse(0).intValue());
        this.completedOperations.set(topology.pendingChanges().map(ClusterChangePlan::completedOperations).map(List::size).orElse(0).intValue());
    }
}

