/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.topology.serializer;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Timestamp;
import io.atomix.cluster.MemberId;
import io.atomix.utils.AbstractIdentifier;
import io.camunda.zeebe.topology.api.ErrorResponse;
import io.camunda.zeebe.topology.api.TopologyChangeResponse;
import io.camunda.zeebe.topology.api.TopologyManagementRequest;
import io.camunda.zeebe.topology.gossip.ClusterTopologyGossipState;
import io.camunda.zeebe.topology.protocol.Requests;
import io.camunda.zeebe.topology.protocol.Topology;
import io.camunda.zeebe.topology.serializer.ClusterTopologySerializer;
import io.camunda.zeebe.topology.serializer.DecodingFailed;
import io.camunda.zeebe.topology.serializer.TopologyRequestsSerializer;
import io.camunda.zeebe.topology.state.ClusterChangePlan;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.state.CompletedChange;
import io.camunda.zeebe.topology.state.MemberState;
import io.camunda.zeebe.topology.state.PartitionState;
import io.camunda.zeebe.topology.state.TopologyChangeOperation;
import io.camunda.zeebe.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProtoBufSerializer
implements ClusterTopologySerializer,
TopologyRequestsSerializer {
    @Override
    public byte[] encode(ClusterTopologyGossipState gossipState) {
        Topology.GossipState.Builder builder = Topology.GossipState.newBuilder();
        ClusterTopology topologyToEncode = gossipState.getClusterTopology();
        if (topologyToEncode != null) {
            Topology.ClusterTopology clusterTopology = this.encodeClusterTopology(topologyToEncode);
            builder.setClusterTopology(clusterTopology);
        }
        Topology.GossipState message = builder.build();
        return message.toByteArray();
    }

    @Override
    public ClusterTopologyGossipState decode(byte[] encodedState) {
        Topology.GossipState gossipState;
        try {
            gossipState = Topology.GossipState.parseFrom(encodedState);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
        ClusterTopologyGossipState clusterTopologyGossipState = new ClusterTopologyGossipState();
        if (gossipState.hasClusterTopology()) {
            try {
                clusterTopologyGossipState.setClusterTopology(this.decodeClusterTopology(gossipState.getClusterTopology()));
            }
            catch (Exception e) {
                throw new DecodingFailed("Cluster topology could not be deserialized from gossiped state: %s".formatted(gossipState), e);
            }
        }
        return clusterTopologyGossipState;
    }

    @Override
    public byte[] encode(ClusterTopology clusterTopology) {
        return this.encodeClusterTopology(clusterTopology).toByteArray();
    }

    @Override
    public ClusterTopology decodeClusterTopology(byte[] encodedClusterTopology, int offset, int length) {
        try {
            Topology.ClusterTopology topology = Topology.ClusterTopology.parseFrom(ByteBuffer.wrap(encodedClusterTopology, offset, length));
            return this.decodeClusterTopology(topology);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    private ClusterTopology decodeClusterTopology(Topology.ClusterTopology encodedClusterTopology) {
        Map<MemberId, MemberState> members = this.decodeMemberStateMap(encodedClusterTopology.getMembersMap());
        Optional<CompletedChange> completedChange = encodedClusterTopology.hasLastChange() ? Optional.of(this.decodeCompletedChange(encodedClusterTopology.getLastChange())) : Optional.empty();
        Optional<ClusterChangePlan> currentChange = encodedClusterTopology.hasCurrentChange() ? Optional.of(this.decodeChangePlan(encodedClusterTopology.getCurrentChange())) : Optional.empty();
        return new ClusterTopology(encodedClusterTopology.getVersion(), members, completedChange, currentChange);
    }

    private Map<MemberId, MemberState> decodeMemberStateMap(Map<String, Topology.MemberState> membersMap) {
        return membersMap.entrySet().stream().map(e -> Map.entry(MemberId.from((String)((String)e.getKey())), this.decodeMemberState((Topology.MemberState)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Topology.ClusterTopology encodeClusterTopology(ClusterTopology clusterTopology) {
        Map<String, Topology.MemberState> members = this.encodeMemberStateMap(clusterTopology.members());
        Topology.ClusterTopology.Builder builder = Topology.ClusterTopology.newBuilder().setVersion(clusterTopology.version()).putAllMembers(members);
        clusterTopology.lastChange().ifPresent(lastChange -> builder.setLastChange(this.encodeCompletedChange((CompletedChange)lastChange)));
        clusterTopology.pendingChanges().ifPresent(changePlan -> builder.setCurrentChange(this.encodeChangePlan((ClusterChangePlan)changePlan)));
        return builder.build();
    }

    private MemberState decodeMemberState(Topology.MemberState memberState) {
        Map<Integer, PartitionState> partitions = memberState.getPartitionsMap().entrySet().stream().map(e -> Map.entry((Integer)e.getKey(), this.decodePartitionState((Topology.PartitionState)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Timestamp lastUpdated = memberState.getLastUpdated();
        return new MemberState(memberState.getVersion(), Instant.ofEpochSecond(lastUpdated.getSeconds(), lastUpdated.getNanos()), this.toMemberState(memberState.getState()), partitions);
    }

    private PartitionState decodePartitionState(Topology.PartitionState partitionState) {
        return new PartitionState(this.toPartitionState(partitionState.getState()), partitionState.getPriority());
    }

    private Topology.MemberState encodeMemberState(MemberState memberState) {
        Map<Integer, Topology.PartitionState> partitions = memberState.partitions().entrySet().stream().map(e -> Map.entry((Integer)e.getKey(), this.encodePartitions((PartitionState)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Instant lastUpdated = memberState.lastUpdated();
        return Topology.MemberState.newBuilder().setVersion(memberState.version()).setLastUpdated(Timestamp.newBuilder().setSeconds(lastUpdated.getEpochSecond()).setNanos(lastUpdated.getNano()).build()).setState(this.toSerializedState(memberState.state())).putAllPartitions(partitions).build();
    }

    private Topology.PartitionState encodePartitions(PartitionState partitionState) {
        return Topology.PartitionState.newBuilder().setState(this.toSerializedState(partitionState.state())).setPriority(partitionState.priority()).build();
    }

    private Topology.State toSerializedState(MemberState.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case MemberState.State.UNINITIALIZED -> Topology.State.UNKNOWN;
            case MemberState.State.ACTIVE -> Topology.State.ACTIVE;
            case MemberState.State.JOINING -> Topology.State.JOINING;
            case MemberState.State.LEAVING -> Topology.State.LEAVING;
            case MemberState.State.LEFT -> Topology.State.LEFT;
        };
    }

    private MemberState.State toMemberState(Topology.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Topology.State.UNRECOGNIZED, Topology.State.UNKNOWN -> MemberState.State.UNINITIALIZED;
            case Topology.State.ACTIVE -> MemberState.State.ACTIVE;
            case Topology.State.JOINING -> MemberState.State.JOINING;
            case Topology.State.LEAVING -> MemberState.State.LEAVING;
            case Topology.State.LEFT -> MemberState.State.LEFT;
        };
    }

    private PartitionState.State toPartitionState(Topology.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Topology.State.UNRECOGNIZED, Topology.State.UNKNOWN, Topology.State.LEFT -> PartitionState.State.UNKNOWN;
            case Topology.State.ACTIVE -> PartitionState.State.ACTIVE;
            case Topology.State.JOINING -> PartitionState.State.JOINING;
            case Topology.State.LEAVING -> PartitionState.State.LEAVING;
        };
    }

    private Topology.State toSerializedState(PartitionState.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case PartitionState.State.UNKNOWN -> Topology.State.UNKNOWN;
            case PartitionState.State.ACTIVE -> Topology.State.ACTIVE;
            case PartitionState.State.JOINING -> Topology.State.JOINING;
            case PartitionState.State.LEAVING -> Topology.State.LEAVING;
        };
    }

    private Topology.ClusterChangePlan encodeChangePlan(ClusterChangePlan changes) {
        Topology.ClusterChangePlan.Builder builder = Topology.ClusterChangePlan.newBuilder().setVersion(changes.version()).setId(changes.id()).setStatus(this.fromTopologyChangeStatus(changes.status())).setStartedAt(Timestamp.newBuilder().setSeconds(changes.startedAt().getEpochSecond()).setNanos(changes.startedAt().getNano()).build());
        changes.pendingOperations().forEach(operation -> builder.addPendingOperations(this.encodeOperation((TopologyChangeOperation)operation)));
        changes.completedOperations().forEach(operation -> builder.addCompletedOperations(this.encodeCompletedOperation((ClusterChangePlan.CompletedOperation)operation)));
        return builder.build();
    }

    private Topology.CompletedChange encodeCompletedChange(CompletedChange completedChange) {
        Topology.CompletedChange.Builder builder = Topology.CompletedChange.newBuilder();
        builder.setId(completedChange.id()).setStatus(this.fromTopologyChangeStatus(completedChange.status())).setCompletedAt(Timestamp.newBuilder().setSeconds(completedChange.completedAt().getEpochSecond()).setNanos(completedChange.completedAt().getNano()).build()).setStartedAt(Timestamp.newBuilder().setSeconds(completedChange.startedAt().getEpochSecond()).setNanos(completedChange.startedAt().getNano()).build());
        return builder.build();
    }

    private Topology.TopologyChangeOperation encodeOperation(TopologyChangeOperation operation) {
        Topology.TopologyChangeOperation.Builder builder = Topology.TopologyChangeOperation.newBuilder().setMemberId((String)((Object)operation.memberId().id()));
        TopologyChangeOperation topologyChangeOperation = operation;
        Objects.requireNonNull(topologyChangeOperation);
        TopologyChangeOperation topologyChangeOperation2 = topologyChangeOperation;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation.class, TopologyChangeOperation.MemberJoinOperation.class, TopologyChangeOperation.MemberLeaveOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation.class, TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation.class, TopologyChangeOperation.MemberRemoveOperation.class}, (Object)topologyChangeOperation2, n)) {
            case 0: {
                TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation joinOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation)topologyChangeOperation2;
                builder.setPartitionJoin(Topology.PartitionJoinOperation.newBuilder().setPartitionId(joinOperation.partitionId()).setPriority(joinOperation.priority()));
                break;
            }
            case 1: {
                TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation leaveOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation)topologyChangeOperation2;
                builder.setPartitionLeave(Topology.PartitionLeaveOperation.newBuilder().setPartitionId(leaveOperation.partitionId()));
                break;
            }
            case 2: {
                TopologyChangeOperation.MemberJoinOperation memberJoinOperation = (TopologyChangeOperation.MemberJoinOperation)topologyChangeOperation2;
                builder.setMemberJoin(Topology.MemberJoinOperation.newBuilder().build());
                break;
            }
            case 3: {
                TopologyChangeOperation.MemberLeaveOperation memberLeaveOperation = (TopologyChangeOperation.MemberLeaveOperation)topologyChangeOperation2;
                builder.setMemberLeave(Topology.MemberLeaveOperation.newBuilder().build());
                break;
            }
            case 4: {
                TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation reconfigurePriorityOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation)topologyChangeOperation2;
                builder.setPartitionReconfigurePriority(Topology.PartitionReconfigurePriorityOperation.newBuilder().setPartitionId(reconfigurePriorityOperation.partitionId()).setPriority(reconfigurePriorityOperation.priority()).build());
                break;
            }
            case 5: {
                TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation forceReconfigureOperation = (TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation)topologyChangeOperation2;
                builder.setPartitionForceReconfigure(Topology.PartitionForceReconfigureOperation.newBuilder().setPartitionId(forceReconfigureOperation.partitionId()).addAllMembers(forceReconfigureOperation.members().stream().map(AbstractIdentifier::id).toList()).build());
                break;
            }
            case 6: {
                TopologyChangeOperation.MemberRemoveOperation memberRemoveOperation = (TopologyChangeOperation.MemberRemoveOperation)topologyChangeOperation2;
                builder.setMemberRemove(Topology.MemberRemoveOperation.newBuilder().setMemberToRemove((String)((Object)memberRemoveOperation.memberToRemove().id())).build());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation type: " + operation.getClass().getSimpleName());
            }
        }
        return builder.build();
    }

    private Topology.CompletedTopologyChangeOperation encodeCompletedOperation(ClusterChangePlan.CompletedOperation completedOperation) {
        return Topology.CompletedTopologyChangeOperation.newBuilder().setOperation(this.encodeOperation(completedOperation.operation())).setCompletedAt(Timestamp.newBuilder().setSeconds(completedOperation.completedAt().getEpochSecond()).setNanos(completedOperation.completedAt().getNano()).build()).build();
    }

    private ClusterChangePlan decodeChangePlan(Topology.ClusterChangePlan clusterChangePlan) {
        int version = clusterChangePlan.getVersion();
        List<TopologyChangeOperation> pendingOperations = clusterChangePlan.getPendingOperationsList().stream().map(this::decodeOperation).collect(Collectors.toList());
        List<ClusterChangePlan.CompletedOperation> completedOperations = clusterChangePlan.getCompletedOperationsList().stream().map(this::decodeCompletedOperation).collect(Collectors.toList());
        return new ClusterChangePlan(clusterChangePlan.getId(), clusterChangePlan.getVersion(), this.toChangeStatus(clusterChangePlan.getStatus()), Instant.ofEpochSecond(clusterChangePlan.getStartedAt().getSeconds(), clusterChangePlan.getStartedAt().getNanos()), completedOperations, pendingOperations);
    }

    private CompletedChange decodeCompletedChange(Topology.CompletedChange completedChange) {
        return new CompletedChange(completedChange.getId(), this.toChangeStatus(completedChange.getStatus()), Instant.ofEpochSecond(completedChange.getStartedAt().getSeconds(), completedChange.getStartedAt().getNanos()), Instant.ofEpochSecond(completedChange.getCompletedAt().getSeconds(), completedChange.getCompletedAt().getNanos()));
    }

    private TopologyChangeOperation decodeOperation(Topology.TopologyChangeOperation topologyChangeOperation) {
        if (topologyChangeOperation.hasPartitionJoin()) {
            return new TopologyChangeOperation.PartitionChangeOperation.PartitionJoinOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), topologyChangeOperation.getPartitionJoin().getPartitionId(), topologyChangeOperation.getPartitionJoin().getPriority());
        }
        if (topologyChangeOperation.hasPartitionLeave()) {
            return new TopologyChangeOperation.PartitionChangeOperation.PartitionLeaveOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), topologyChangeOperation.getPartitionLeave().getPartitionId());
        }
        if (topologyChangeOperation.hasMemberJoin()) {
            return new TopologyChangeOperation.MemberJoinOperation(MemberId.from((String)topologyChangeOperation.getMemberId()));
        }
        if (topologyChangeOperation.hasMemberLeave()) {
            return new TopologyChangeOperation.MemberLeaveOperation(MemberId.from((String)topologyChangeOperation.getMemberId()));
        }
        if (topologyChangeOperation.hasPartitionReconfigurePriority()) {
            return new TopologyChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), topologyChangeOperation.getPartitionReconfigurePriority().getPartitionId(), topologyChangeOperation.getPartitionReconfigurePriority().getPriority());
        }
        if (topologyChangeOperation.hasPartitionForceReconfigure()) {
            return new TopologyChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), topologyChangeOperation.getPartitionForceReconfigure().getPartitionId(), topologyChangeOperation.getPartitionForceReconfigure().getMembersList().stream().map(MemberId::from).toList());
        }
        if (topologyChangeOperation.hasMemberRemove()) {
            return new TopologyChangeOperation.MemberRemoveOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), MemberId.from((String)topologyChangeOperation.getMemberRemove().getMemberToRemove()));
        }
        throw new IllegalStateException("Unknown operation: " + String.valueOf(topologyChangeOperation));
    }

    private ClusterChangePlan.CompletedOperation decodeCompletedOperation(Topology.CompletedTopologyChangeOperation operation) {
        return new ClusterChangePlan.CompletedOperation(this.decodeOperation(operation.getOperation()), Instant.ofEpochSecond(operation.getCompletedAt().getSeconds()));
    }

    @Override
    public byte[] encodeAddMembersRequest(TopologyManagementRequest.AddMembersRequest req) {
        return Requests.AddMembersRequest.newBuilder().addAllMemberIds(req.members().stream().map(AbstractIdentifier::id).toList()).setDryRun(req.dryRun()).build().toByteArray();
    }

    @Override
    public byte[] encodeRemoveMembersRequest(TopologyManagementRequest.RemoveMembersRequest req) {
        return Requests.RemoveMembersRequest.newBuilder().addAllMemberIds(req.members().stream().map(AbstractIdentifier::id).toList()).setDryRun(req.dryRun()).build().toByteArray();
    }

    @Override
    public byte[] encodeJoinPartitionRequest(TopologyManagementRequest.JoinPartitionRequest req) {
        return Requests.JoinPartitionRequest.newBuilder().setMemberId((String)((Object)req.memberId().id())).setPartitionId(req.partitionId()).setPriority(req.priority()).setDryRun(req.dryRun()).build().toByteArray();
    }

    @Override
    public byte[] encodeLeavePartitionRequest(TopologyManagementRequest.LeavePartitionRequest req) {
        return Requests.LeavePartitionRequest.newBuilder().setMemberId((String)((Object)req.memberId().id())).setPartitionId(req.partitionId()).setDryRun(req.dryRun()).build().toByteArray();
    }

    @Override
    public byte[] encodeReassignPartitionsRequest(TopologyManagementRequest.ReassignPartitionsRequest reassignPartitionsRequest) {
        return Requests.ReassignAllPartitionsRequest.newBuilder().addAllMemberIds(reassignPartitionsRequest.members().stream().map(AbstractIdentifier::id).toList()).setDryRun(reassignPartitionsRequest.dryRun()).build().toByteArray();
    }

    @Override
    public byte[] encodeScaleRequest(TopologyManagementRequest.ScaleRequest scaleRequest) {
        Requests.ScaleRequest.Builder builder = Requests.ScaleRequest.newBuilder().addAllMemberIds(scaleRequest.members().stream().map(AbstractIdentifier::id).toList()).setDryRun(scaleRequest.dryRun());
        scaleRequest.newReplicationFactor().ifPresent(builder::setNewReplicationFactor);
        return builder.build().toByteArray();
    }

    @Override
    public byte[] encodeCancelChangeRequest(TopologyManagementRequest.CancelChangeRequest cancelChangeRequest) {
        return Requests.CancelTopologyChangeRequest.newBuilder().setChangeId(cancelChangeRequest.changeId()).build().toByteArray();
    }

    @Override
    public TopologyManagementRequest.AddMembersRequest decodeAddMembersRequest(byte[] encodedState) {
        try {
            Requests.AddMembersRequest addMemberRequest = Requests.AddMembersRequest.parseFrom(encodedState);
            return new TopologyManagementRequest.AddMembersRequest(addMemberRequest.getMemberIdsList().stream().map(MemberId::from).collect(Collectors.toSet()), addMemberRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public TopologyManagementRequest.RemoveMembersRequest decodeRemoveMembersRequest(byte[] encodedState) {
        try {
            Requests.RemoveMembersRequest removeMemberRequest = Requests.RemoveMembersRequest.parseFrom(encodedState);
            return new TopologyManagementRequest.RemoveMembersRequest(removeMemberRequest.getMemberIdsList().stream().map(MemberId::from).collect(Collectors.toSet()), removeMemberRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public TopologyManagementRequest.JoinPartitionRequest decodeJoinPartitionRequest(byte[] encodedState) {
        try {
            Requests.JoinPartitionRequest joinPartitionRequest = Requests.JoinPartitionRequest.parseFrom(encodedState);
            return new TopologyManagementRequest.JoinPartitionRequest(MemberId.from((String)joinPartitionRequest.getMemberId()), joinPartitionRequest.getPartitionId(), joinPartitionRequest.getPriority(), joinPartitionRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public TopologyManagementRequest.LeavePartitionRequest decodeLeavePartitionRequest(byte[] encodedState) {
        try {
            Requests.LeavePartitionRequest leavePartitionRequest = Requests.LeavePartitionRequest.parseFrom(encodedState);
            return new TopologyManagementRequest.LeavePartitionRequest(MemberId.from((String)leavePartitionRequest.getMemberId()), leavePartitionRequest.getPartitionId(), leavePartitionRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public TopologyManagementRequest.ReassignPartitionsRequest decodeReassignPartitionsRequest(byte[] encodedState) {
        try {
            Requests.ReassignAllPartitionsRequest reassignPartitionsRequest = Requests.ReassignAllPartitionsRequest.parseFrom(encodedState);
            return new TopologyManagementRequest.ReassignPartitionsRequest(reassignPartitionsRequest.getMemberIdsList().stream().map(MemberId::from).collect(Collectors.toSet()), reassignPartitionsRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public TopologyManagementRequest.ScaleRequest decodeScaleRequest(byte[] encodedState) {
        try {
            Requests.ScaleRequest scaleRequest = Requests.ScaleRequest.parseFrom(encodedState);
            Optional<Integer> newReplicationFactor = scaleRequest.hasNewReplicationFactor() ? Optional.of(scaleRequest.getNewReplicationFactor()) : Optional.empty();
            return new TopologyManagementRequest.ScaleRequest(scaleRequest.getMemberIdsList().stream().map(MemberId::from).collect(Collectors.toSet()), newReplicationFactor, scaleRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public TopologyManagementRequest.CancelChangeRequest decodeCancelChangeRequest(byte[] encodedState) {
        try {
            Requests.CancelTopologyChangeRequest cancelChangeRequest = Requests.CancelTopologyChangeRequest.parseFrom(encodedState);
            return new TopologyManagementRequest.CancelChangeRequest(cancelChangeRequest.getChangeId());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public byte[] encodeResponse(TopologyChangeResponse response) {
        return Requests.Response.newBuilder().setTopologyChangeResponse(this.encodeTopologyChangeResponse(response)).build().toByteArray();
    }

    @Override
    public byte[] encodeResponse(ClusterTopology response) {
        return Requests.Response.newBuilder().setClusterTopology(this.encodeClusterTopology(response)).build().toByteArray();
    }

    @Override
    public byte[] encodeResponse(ErrorResponse response) {
        return Requests.Response.newBuilder().setError(Requests.ErrorResponse.newBuilder().setErrorCode(this.encodeErrorCode(response.code())).setErrorMessage(response.message())).build().toByteArray();
    }

    @Override
    public Either<ErrorResponse, TopologyChangeResponse> decodeTopologyChangeResponse(byte[] encodedResponse) {
        try {
            Requests.Response response = Requests.Response.parseFrom(encodedResponse);
            if (response.hasError()) {
                return Either.left((Object)new ErrorResponse(this.decodeErrorCode(response.getError().getErrorCode()), response.getError().getErrorMessage()));
            }
            if (response.hasTopologyChangeResponse()) {
                return Either.right((Object)this.decodeTopologyChangeResponse(response.getTopologyChangeResponse()));
            }
            throw new DecodingFailed("Response does not have an error or a valid topology change response");
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public Either<ErrorResponse, ClusterTopology> decodeClusterTopologyResponse(byte[] encodedResponse) {
        try {
            Requests.Response response = Requests.Response.parseFrom(encodedResponse);
            if (response.hasError()) {
                return Either.left((Object)new ErrorResponse(this.decodeErrorCode(response.getError().getErrorCode()), response.getError().getErrorMessage()));
            }
            if (response.hasClusterTopology()) {
                return Either.right((Object)this.decodeClusterTopology(response.getClusterTopology()));
            }
            throw new DecodingFailed("Response does not have an error or a valid cluster topology");
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    public Requests.TopologyChangeResponse.Builder encodeTopologyChangeResponse(TopologyChangeResponse topologyChangeResponse) {
        Requests.TopologyChangeResponse.Builder builder = Requests.TopologyChangeResponse.newBuilder();
        builder.setChangeId(topologyChangeResponse.changeId()).addAllPlannedChanges(topologyChangeResponse.plannedChanges().stream().map(this::encodeOperation).toList()).putAllCurrentTopology(this.encodeMemberStateMap(topologyChangeResponse.currentTopology())).putAllExpectedTopology(this.encodeMemberStateMap(topologyChangeResponse.expectedTopology()));
        return builder;
    }

    public TopologyChangeResponse decodeTopologyChangeResponse(Requests.TopologyChangeResponse topologyChangeResponse) {
        return new TopologyChangeResponse(topologyChangeResponse.getChangeId(), this.decodeMemberStateMap(topologyChangeResponse.getCurrentTopologyMap()), this.decodeMemberStateMap(topologyChangeResponse.getExpectedTopologyMap()), topologyChangeResponse.getPlannedChangesList().stream().map(this::decodeOperation).collect(Collectors.toList()));
    }

    private Requests.ErrorCode encodeErrorCode(ErrorResponse.ErrorCode status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case ErrorResponse.ErrorCode.INVALID_REQUEST -> Requests.ErrorCode.INVALID_REQUEST;
            case ErrorResponse.ErrorCode.OPERATION_NOT_ALLOWED -> Requests.ErrorCode.OPERATION_NOT_ALLOWED;
            case ErrorResponse.ErrorCode.CONCURRENT_MODIFICATION -> Requests.ErrorCode.CONCURRENT_MODIFICATION;
            case ErrorResponse.ErrorCode.INTERNAL_ERROR -> Requests.ErrorCode.INTERNAL_ERROR;
        };
    }

    private ErrorResponse.ErrorCode decodeErrorCode(Requests.ErrorCode status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case Requests.ErrorCode.INVALID_REQUEST -> ErrorResponse.ErrorCode.INVALID_REQUEST;
            case Requests.ErrorCode.OPERATION_NOT_ALLOWED -> ErrorResponse.ErrorCode.OPERATION_NOT_ALLOWED;
            case Requests.ErrorCode.CONCURRENT_MODIFICATION -> ErrorResponse.ErrorCode.CONCURRENT_MODIFICATION;
            case Requests.ErrorCode.INTERNAL_ERROR, Requests.ErrorCode.UNRECOGNIZED -> ErrorResponse.ErrorCode.INTERNAL_ERROR;
        };
    }

    private Map<String, Topology.MemberState> encodeMemberStateMap(Map<MemberId, MemberState> topologyChangeResponse) {
        return topologyChangeResponse.entrySet().stream().collect(Collectors.toMap(e -> (String)((Object)((MemberId)e.getKey()).id()), e -> this.encodeMemberState((MemberState)e.getValue())));
    }

    private Topology.ChangeStatus fromTopologyChangeStatus(ClusterChangePlan.Status status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case ClusterChangePlan.Status.IN_PROGRESS -> Topology.ChangeStatus.IN_PROGRESS;
            case ClusterChangePlan.Status.COMPLETED -> Topology.ChangeStatus.COMPLETED;
            case ClusterChangePlan.Status.FAILED -> Topology.ChangeStatus.FAILED;
            case ClusterChangePlan.Status.CANCELLED -> Topology.ChangeStatus.CANCELLED;
        };
    }

    private ClusterChangePlan.Status toChangeStatus(Topology.ChangeStatus status) {
        return switch (status) {
            case Topology.ChangeStatus.IN_PROGRESS -> ClusterChangePlan.Status.IN_PROGRESS;
            case Topology.ChangeStatus.COMPLETED -> ClusterChangePlan.Status.COMPLETED;
            case Topology.ChangeStatus.FAILED -> ClusterChangePlan.Status.FAILED;
            case Topology.ChangeStatus.CANCELLED -> ClusterChangePlan.Status.CANCELLED;
            default -> throw new IllegalStateException("Unknown status: " + String.valueOf((Object)status));
        };
    }
}

