/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb.transaction;

import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.impl.ZeebeDbConstants;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.ObjIntConsumer;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ColumnFamilyContext {
    private static final byte[] ZERO_SIZE_ARRAY = new byte[0];
    private final ExpandableArrayBuffer keyBuffer = new ExpandableArrayBuffer();
    private final ExpandableArrayBuffer valueBuffer = new ExpandableArrayBuffer();
    private final DirectBuffer keyViewBuffer = new UnsafeBuffer(0L, 0);
    private final DirectBuffer valueViewBuffer = new UnsafeBuffer(0L, 0);
    private final Queue<ExpandableArrayBuffer> prefixKeyBuffers;
    private int keyLength;
    private final long columnFamilyPrefix;

    ColumnFamilyContext(long columnFamilyPrefix) {
        this.columnFamilyPrefix = columnFamilyPrefix;
        this.prefixKeyBuffers = new ArrayDeque<ExpandableArrayBuffer>();
        this.prefixKeyBuffers.add(new ExpandableArrayBuffer());
        this.prefixKeyBuffers.add(new ExpandableArrayBuffer());
    }

    public void writeKey(DbKey key) {
        this.keyLength = 0;
        this.keyBuffer.putLong(0, this.columnFamilyPrefix, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.keyLength += 8;
        key.write((MutableDirectBuffer)this.keyBuffer, 8);
        this.keyLength += key.getLength();
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public byte[] getKeyBufferArray() {
        return this.keyBuffer.byteArray();
    }

    public void writeValue(DbValue value) {
        value.write((MutableDirectBuffer)this.valueBuffer, 0);
    }

    public byte[] getValueBufferArray() {
        return this.valueBuffer.byteArray();
    }

    public void wrapKeyView(byte[] key) {
        if (key != null) {
            this.keyViewBuffer.wrap(key, 8, key.length - 8);
        } else {
            this.keyViewBuffer.wrap(ZERO_SIZE_ARRAY);
        }
    }

    public DirectBuffer getKeyView() {
        return this.isKeyViewEmpty() ? null : this.keyViewBuffer;
    }

    public boolean isKeyViewEmpty() {
        return this.keyViewBuffer.capacity() == ZERO_SIZE_ARRAY.length;
    }

    public void wrapValueView(byte[] value) {
        if (value != null) {
            this.valueViewBuffer.wrap(value);
        } else {
            this.valueViewBuffer.wrap(ZERO_SIZE_ARRAY);
        }
    }

    public DirectBuffer getValueView() {
        return this.isValueViewEmpty() ? null : this.valueViewBuffer;
    }

    public boolean isValueViewEmpty() {
        return this.valueViewBuffer.capacity() == ZERO_SIZE_ARRAY.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withPrefixKey(DbKey key, ObjIntConsumer<byte[]> prefixKeyConsumer) {
        if (this.prefixKeyBuffers.peek() == null) {
            throw new IllegalStateException("Currently nested prefix iterations are not supported! This will cause unexpected behavior.");
        }
        ExpandableArrayBuffer prefixKeyBuffer = this.prefixKeyBuffers.remove();
        try {
            prefixKeyBuffer.putLong(0, this.columnFamilyPrefix, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
            key.write((MutableDirectBuffer)prefixKeyBuffer, 8);
            int prefixLength = 8 + key.getLength();
            prefixKeyConsumer.accept(prefixKeyBuffer.byteArray(), prefixLength);
        }
        finally {
            this.prefixKeyBuffers.add(prefixKeyBuffer);
        }
    }

    ByteBuffer keyWithColumnFamily(DbKey key) {
        ByteBuffer bytes = ByteBuffer.allocate(8 + key.getLength());
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        buffer.putLong(0, this.columnFamilyPrefix, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        key.write((MutableDirectBuffer)buffer, 8);
        return bytes;
    }
}

