/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb.transaction;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.ConsistencyChecksSettings;
import io.camunda.zeebe.db.ContainsForeignKeys;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.KeyValuePairVisitor;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDbInconsistentException;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ColumnFamilyContext;
import io.camunda.zeebe.db.impl.rocksdb.transaction.DbNullKey;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ForeignKeyChecker;
import io.camunda.zeebe.db.impl.rocksdb.transaction.TransactionConsumer;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ZeebeTransaction;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ZeebeTransactionDb;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksIterator;

class TransactionalColumnFamily<ColumnFamilyNames extends Enum<ColumnFamilyNames>, KeyType extends DbKey, ValueType extends DbValue>
implements ColumnFamily<KeyType, ValueType> {
    private final ZeebeTransactionDb<ColumnFamilyNames> transactionDb;
    private final ConsistencyChecksSettings consistencyChecksSettings;
    private final ColumnFamilyNames columnFamily;
    private final TransactionContext context;
    private final ValueType valueInstance;
    private final KeyType keyInstance;
    private final ColumnFamilyContext columnFamilyContext;
    private final ForeignKeyChecker foreignKeyChecker;

    TransactionalColumnFamily(ZeebeTransactionDb<ColumnFamilyNames> transactionDb, ConsistencyChecksSettings consistencyChecksSettings, ColumnFamilyNames columnFamily, TransactionContext context, KeyType keyInstance, ValueType valueInstance) {
        this.transactionDb = transactionDb;
        this.consistencyChecksSettings = consistencyChecksSettings;
        this.columnFamily = columnFamily;
        this.context = context;
        this.keyInstance = keyInstance;
        this.valueInstance = valueInstance;
        this.columnFamilyContext = new ColumnFamilyContext(((Enum)columnFamily).ordinal());
        this.foreignKeyChecker = new ForeignKeyChecker(transactionDb, consistencyChecksSettings);
    }

    @Override
    public void insert(KeyType key, ValueType value) {
        this.ensureInOpenTransaction(transaction -> {
            this.columnFamilyContext.writeKey((DbKey)key);
            this.columnFamilyContext.writeValue((DbValue)value);
            this.assertKeyDoesNotExist(transaction);
            this.assertForeignKeysExist(transaction, key, value);
            transaction.put(this.transactionDb.getDefaultNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength(), this.columnFamilyContext.getValueBufferArray(), value.getLength());
        });
    }

    @Override
    public void update(KeyType key, ValueType value) {
        this.ensureInOpenTransaction(transaction -> {
            this.columnFamilyContext.writeKey((DbKey)key);
            this.columnFamilyContext.writeValue((DbValue)value);
            this.assertKeyExists(transaction);
            this.assertForeignKeysExist(transaction, key, value);
            transaction.put(this.transactionDb.getDefaultNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength(), this.columnFamilyContext.getValueBufferArray(), value.getLength());
        });
    }

    @Override
    public void upsert(KeyType key, ValueType value) {
        this.ensureInOpenTransaction(transaction -> {
            this.columnFamilyContext.writeKey((DbKey)key);
            this.columnFamilyContext.writeValue((DbValue)value);
            this.assertForeignKeysExist(transaction, key, value);
            transaction.put(this.transactionDb.getDefaultNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength(), this.columnFamilyContext.getValueBufferArray(), value.getLength());
        });
    }

    @Override
    public ValueType get(KeyType key) {
        this.ensureInOpenTransaction(transaction -> {
            this.columnFamilyContext.writeKey((DbKey)key);
            byte[] value = transaction.get(this.transactionDb.getDefaultNativeHandle(), this.transactionDb.getReadOptionsNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength());
            this.columnFamilyContext.wrapValueView(value);
        });
        DirectBuffer valueBuffer = this.columnFamilyContext.getValueView();
        if (valueBuffer != null) {
            this.valueInstance.wrap(valueBuffer, 0, valueBuffer.capacity());
            return this.valueInstance;
        }
        return null;
    }

    @Override
    public void forEach(Consumer<ValueType> consumer) {
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix(new DbNullKey(), (k, v) -> {
            consumer.accept(v);
            return true;
        }));
    }

    @Override
    public void forEach(BiConsumer<KeyType, ValueType> consumer) {
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix(new DbNullKey(), (k, v) -> {
            consumer.accept(k, v);
            return true;
        }));
    }

    @Override
    public void whileTrue(KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix(new DbNullKey(), visitor));
    }

    @Override
    public void whileEqualPrefix(DbKey keyPrefix, BiConsumer<KeyType, ValueType> visitor) {
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix(keyPrefix, (k, v) -> {
            visitor.accept(k, v);
            return true;
        }));
    }

    @Override
    public void whileEqualPrefix(DbKey keyPrefix, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix(keyPrefix, visitor));
    }

    @Override
    public void deleteExisting(KeyType key) {
        this.ensureInOpenTransaction(transaction -> {
            this.columnFamilyContext.writeKey((DbKey)key);
            this.assertKeyExists(transaction);
            transaction.delete(this.transactionDb.getDefaultNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength());
        });
    }

    @Override
    public void deleteIfExists(KeyType key) {
        this.ensureInOpenTransaction(transaction -> {
            this.columnFamilyContext.writeKey((DbKey)key);
            transaction.delete(this.transactionDb.getDefaultNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength());
        });
    }

    @Override
    public boolean exists(KeyType key) {
        this.ensureInOpenTransaction(transaction -> {
            this.columnFamilyContext.writeKey((DbKey)key);
            byte[] value = transaction.get(this.transactionDb.getDefaultNativeHandle(), this.transactionDb.getReadOptionsNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength());
            this.columnFamilyContext.wrapValueView(value);
        });
        return !this.columnFamilyContext.isValueViewEmpty();
    }

    @Override
    public boolean isEmpty() {
        AtomicBoolean isEmpty = new AtomicBoolean(true);
        this.ensureInOpenTransaction(transaction -> this.forEachInPrefix(new DbNullKey(), (key, value) -> {
            isEmpty.set(false);
            return false;
        }));
        return isEmpty.get();
    }

    private void assertForeignKeysExist(ZeebeTransaction transaction, Object ... keys) throws Exception {
        if (!this.consistencyChecksSettings.enableForeignKeyChecks()) {
            return;
        }
        for (Object key : keys) {
            if (!(key instanceof ContainsForeignKeys)) continue;
            ContainsForeignKeys containsForeignKey = (ContainsForeignKeys)key;
            this.foreignKeyChecker.assertExists(transaction, containsForeignKey);
        }
    }

    private void assertKeyDoesNotExist(ZeebeTransaction transaction) throws Exception {
        if (!this.consistencyChecksSettings.enablePreconditions()) {
            return;
        }
        byte[] value = transaction.get(this.transactionDb.getDefaultNativeHandle(), this.transactionDb.getReadOptionsNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength());
        if (value != null) {
            throw new ZeebeDbInconsistentException("Key " + this.keyInstance + " in ColumnFamily " + this.columnFamily + " already exists");
        }
    }

    private void assertKeyExists(ZeebeTransaction transaction) throws Exception {
        if (!this.consistencyChecksSettings.enablePreconditions()) {
            return;
        }
        byte[] value = transaction.get(this.transactionDb.getDefaultNativeHandle(), this.transactionDb.getReadOptionsNativeHandle(), this.columnFamilyContext.getKeyBufferArray(), this.columnFamilyContext.getKeyLength());
        if (value == null) {
            throw new ZeebeDbInconsistentException("Key " + this.keyInstance + " in ColumnFamily " + this.columnFamily + " does not exist");
        }
    }

    private void ensureInOpenTransaction(TransactionConsumer operation) {
        this.context.runInTransaction(() -> operation.run((ZeebeTransaction)this.context.getCurrentTransaction()));
    }

    RocksIterator newIterator(TransactionContext context, ReadOptions options) {
        ZeebeTransaction currentTransaction = (ZeebeTransaction)context.getCurrentTransaction();
        return currentTransaction.newIterator(options, this.transactionDb.getDefaultHandle());
    }

    private void forEachInPrefix(DbKey prefix, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.columnFamilyContext.withPrefixKey(prefix, (prefixKey, prefixLength) -> {
            try (RocksIterator iterator = this.newIterator(this.context, this.transactionDb.getPrefixReadOptions());){
                boolean shouldVisitNext = true;
                ByteBuffer bufferView = ByteBuffer.wrap(prefixKey, 0, prefixLength);
                iterator.seek(bufferView);
                while (iterator.isValid() && shouldVisitNext) {
                    byte[] keyBytes = iterator.key();
                    if (!BufferUtil.startsWith((byte[])prefixKey, (int)0, (int)prefixLength, (byte[])keyBytes, (int)0, (int)keyBytes.length)) {
                        break;
                    }
                    shouldVisitNext = this.visit(this.keyInstance, this.valueInstance, visitor, iterator);
                    iterator.next();
                }
            }
        });
    }

    private boolean visit(KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> iteratorConsumer, RocksIterator iterator) {
        byte[] keyBytes = iterator.key();
        this.columnFamilyContext.wrapKeyView(keyBytes);
        this.columnFamilyContext.wrapValueView(iterator.value());
        DirectBuffer keyViewBuffer = this.columnFamilyContext.getKeyView();
        keyInstance.wrap(keyViewBuffer, 0, keyViewBuffer.capacity());
        DirectBuffer valueViewBuffer = this.columnFamilyContext.getValueView();
        valueInstance.wrap(valueViewBuffer, 0, valueViewBuffer.capacity());
        return iteratorConsumer.visit(keyInstance, valueInstance);
    }
}

