/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb;

import io.camunda.zeebe.db.ConsistencyChecksSettings;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.ZeebeDbFactory;
import io.camunda.zeebe.db.impl.rocksdb.RocksDbConfiguration;
import io.camunda.zeebe.db.impl.rocksdb.SnapshotOnlyDb;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ZeebeTransactionDb;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.agrona.CloseHelper;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DataBlockIndexType;
import org.rocksdb.Filter;
import org.rocksdb.IndexType;
import org.rocksdb.LRUCache;
import org.rocksdb.Options;
import org.rocksdb.RateLimiter;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.SstPartitionerFactory;
import org.rocksdb.SstPartitionerFixedPrefixFactory;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.TableFormatConfig;

public final class ZeebeRocksDbFactory<ColumnFamilyType extends Enum<ColumnFamilyType>>
implements ZeebeDbFactory<ColumnFamilyType> {
    private final RocksDbConfiguration rocksDbConfiguration;
    private final ConsistencyChecksSettings consistencyChecksSettings;

    public ZeebeRocksDbFactory(RocksDbConfiguration rocksDbConfiguration, ConsistencyChecksSettings consistencyChecksSettings) {
        this.rocksDbConfiguration = Objects.requireNonNull(rocksDbConfiguration);
        this.consistencyChecksSettings = Objects.requireNonNull(consistencyChecksSettings);
    }

    @Override
    public ZeebeTransactionDb<ColumnFamilyType> createDb(File pathName) {
        List<AutoCloseable> closeables = Collections.synchronizedList(new ArrayList());
        try {
            return ZeebeTransactionDb.openTransactionalDb(this.prepareOptions(closeables), pathName.getAbsolutePath(), closeables, this.rocksDbConfiguration, this.consistencyChecksSettings);
        }
        catch (RocksDBException e) {
            CloseHelper.quietCloseAll(closeables);
            throw new IllegalStateException("Unexpected error occurred trying to open the database", e);
        }
    }

    @Override
    public ZeebeDb<ColumnFamilyType> openSnapshotOnlyDb(File pathName) {
        List<AutoCloseable> managedResources = Collections.synchronizedList(new ArrayList());
        Options options = this.prepareOptions(managedResources);
        options.setCreateIfMissing(false).setSkipCheckingSstFileSizesOnDbOpen(true);
        try {
            return SnapshotOnlyDb.openDb(options, pathName.getAbsolutePath(), managedResources);
        }
        catch (RocksDBException e) {
            CloseHelper.quietCloseAll(managedResources);
            throw new IllegalStateException("Unexpected error occurred trying to open a snapshot-only database", e);
        }
    }

    private Options prepareOptions(List<AutoCloseable> managedResources) {
        ColumnFamilyOptions columnFamilyOptions = this.createColumnFamilyOptions(managedResources);
        managedResources.add((AutoCloseable)columnFamilyOptions);
        DBOptions dbOptions = this.createDefaultDbOptions(managedResources);
        managedResources.add((AutoCloseable)dbOptions);
        Options options = new Options(dbOptions, columnFamilyOptions);
        managedResources.add((AutoCloseable)options);
        return options;
    }

    private DBOptions createDefaultDbOptions(List<AutoCloseable> closeables) {
        DBOptions dbOptions = new DBOptions().setErrorIfExists(false).setCreateIfMissing(true).setParanoidChecks(true).setMaxOpenFiles(this.rocksDbConfiguration.getMaxOpenFiles()).setMaxBackgroundJobs(2).setCreateMissingColumnFamilies(false).setAvoidFlushDuringRecovery(true).setMaxManifestFileSize(0x10000000L).setLogFileTimeToRoll(Duration.ofMinutes(30L).toSeconds()).setKeepLogFileNum(2L);
        if (this.rocksDbConfiguration.getIoRateBytesPerSecond() > 0) {
            RateLimiter rateLimiter = new RateLimiter((long)this.rocksDbConfiguration.getIoRateBytesPerSecond());
            dbOptions.setRateLimiter(rateLimiter);
        }
        if (this.rocksDbConfiguration.isStatisticsEnabled()) {
            Statistics statistics = new Statistics();
            closeables.add((AutoCloseable)statistics);
            statistics.setStatsLevel(StatsLevel.ALL);
            dbOptions.setStatistics(statistics).setSkipStatsUpdateOnDbOpen(true).setStatsDumpPeriodSec(20);
        }
        return dbOptions;
    }

    ColumnFamilyOptions createColumnFamilyOptions(List<AutoCloseable> closeables) {
        boolean hasUserOptions;
        Properties userProvidedColumnFamilyOptions = this.rocksDbConfiguration.getColumnFamilyOptions();
        boolean bl = hasUserOptions = !userProvidedColumnFamilyOptions.isEmpty();
        if (hasUserOptions) {
            return this.createFromUserOptions(userProvidedColumnFamilyOptions);
        }
        return this.createDefaultColumnFamilyOptions(closeables);
    }

    private ColumnFamilyOptions createFromUserOptions(Properties userProvidedColumnFamilyOptions) {
        ColumnFamilyOptions columnFamilyOptions = ColumnFamilyOptions.getColumnFamilyOptionsFromProps((Properties)userProvidedColumnFamilyOptions);
        if (columnFamilyOptions == null) {
            throw new IllegalStateException(String.format("Expected to create column family options for RocksDB, but one or many values are undefined in the context of RocksDB [User-provided ColumnFamilyOptions: %s]. See RocksDB's cf_options.h and options_helper.cc for available keys and values.", userProvidedColumnFamilyOptions));
        }
        return columnFamilyOptions;
    }

    private ColumnFamilyOptions createDefaultColumnFamilyOptions(List<AutoCloseable> closeables) {
        ColumnFamilyOptions columnFamilyOptions = new ColumnFamilyOptions();
        long totalMemoryBudget = this.rocksDbConfiguration.getMemoryLimit();
        long blockCacheMemory = totalMemoryBudget / 3L;
        int maxConcurrentMemtableCount = this.rocksDbConfiguration.getMaxWriteBufferNumber();
        double memtablePrefixFilterMemory = 0.15;
        long memtableMemory = Math.round((double)(totalMemoryBudget - blockCacheMemory) / (double)maxConcurrentMemtableCount * 0.85);
        TableFormatConfig tableConfig = this.createTableFormatConfig(closeables, blockCacheMemory);
        if (this.rocksDbConfiguration.isSstPartitioningEnabled()) {
            columnFamilyOptions.setSstPartitionerFactory((SstPartitionerFactory)new SstPartitionerFixedPrefixFactory(8L));
        }
        return columnFamilyOptions.useFixedLengthPrefixExtractor(8).setMemtablePrefixBloomSizeRatio(0.15).setMinWriteBufferNumberToMerge(this.rocksDbConfiguration.getMinWriteBufferNumberToMerge()).setMaxWriteBufferNumberToMaintain(maxConcurrentMemtableCount).setMaxWriteBufferNumber(maxConcurrentMemtableCount).setWriteBufferSize(memtableMemory).setLevelCompactionDynamicLevelBytes(true).setCompactionPriority(CompactionPriority.OldestSmallestSeqFirst).setCompactionStyle(CompactionStyle.LEVEL).setLevel0FileNumCompactionTrigger(maxConcurrentMemtableCount).setLevel0SlowdownWritesTrigger(maxConcurrentMemtableCount + maxConcurrentMemtableCount / 2).setLevel0StopWritesTrigger(maxConcurrentMemtableCount * 2).setNumLevels(4).setMaxBytesForLevelBase(0x2000000L).setMaxBytesForLevelMultiplier(10.0).setCompressionPerLevel(List.of(CompressionType.NO_COMPRESSION, CompressionType.NO_COMPRESSION, CompressionType.LZ4_COMPRESSION, CompressionType.LZ4_COMPRESSION)).setTargetFileSizeBase(0x800000L).setTargetFileSizeMultiplier(2).setTableFormatConfig(tableConfig);
    }

    private TableFormatConfig createTableFormatConfig(List<AutoCloseable> closeables, long blockCacheMemory) {
        LRUCache cache = new LRUCache(blockCacheMemory, 8, false, 0.15);
        closeables.add((AutoCloseable)cache);
        BloomFilter filter = new BloomFilter(10.0, false);
        closeables.add((AutoCloseable)filter);
        return new BlockBasedTableConfig().setBlockCache((Cache)cache).setBlockSize(32768L).setFormatVersion(5).setFilterPolicy((Filter)filter).setCacheIndexAndFilterBlocks(true).setPinL0FilterAndIndexBlocksInCache(true).setCacheIndexAndFilterBlocksWithHighPriority(true).setIndexType(IndexType.kHashSearch).setDataBlockIndexType(DataBlockIndexType.kDataBlockBinaryAndHash).setDataBlockHashTableUtilRatio(0.75).setWholeKeyFiltering(true);
    }

    static {
        RocksDB.loadLibrary();
    }
}

