/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public enum ColumnFamilyMetricsDoc implements ExtendedMeterDocumentation
{
    LATENCY{
        private static final KeyName[] KEYS = new KeyName[]{MicrometerUtil.PartitionKeyNames.PARTITION, ColumnFamilyMetricsKeyName.COLUMN_FAMILY, ColumnFamilyMetricsKeyName.OPERATION};
        private static final Duration[] BUCKETS = MicrometerUtil.exponentialBucketDuration((long)10L, (long)2L, (int)15, (TemporalUnit)ChronoUnit.MICROS);

        public String getName() {
            return "zeebe.rocksdb.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public String getDescription() {
            return "Latency of RocksDB operations per column family";
        }

        public Duration[] getTimerSLOs() {
            return BUCKETS;
        }

        public KeyName[] getKeyNames() {
            return KEYS;
        }
    };


    public static enum OperationType {
        GET("get"),
        PUT("put"),
        DELETE("delete"),
        ITERATE("iterate");

        private final String name;

        private OperationType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum ColumnFamilyMetricsKeyName implements KeyName
    {
        COLUMN_FAMILY{

            public String asString() {
                return "columnFamily";
            }
        }
        ,
        OPERATION{

            public String asString() {
                return "operation";
            }
        };

    }
}

