/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl;

import io.camunda.zeebe.db.ColumnFamilyMetrics;
import io.camunda.zeebe.db.ColumnFamilyMetricsDoc;
import io.camunda.zeebe.protocol.EnumValue;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Objects;

public final class FineGrainedColumnFamilyMetrics
implements ColumnFamilyMetrics {
    private final Timer get;
    private final Timer put;
    private final Timer delete;
    private final Timer iterate;
    private final MeterRegistry registry;

    public <ColumnFamilyNames extends Enum<? extends EnumValue>> FineGrainedColumnFamilyMetrics(ColumnFamilyNames columnFamily, MeterRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry cannot be null");
        String columnFamilyLabel = columnFamily.name();
        this.get = this.createTimer(columnFamilyLabel, ColumnFamilyMetricsDoc.OperationType.GET);
        this.put = this.createTimer(columnFamilyLabel, ColumnFamilyMetricsDoc.OperationType.PUT);
        this.delete = this.createTimer(columnFamilyLabel, ColumnFamilyMetricsDoc.OperationType.DELETE);
        this.iterate = this.createTimer(columnFamilyLabel, ColumnFamilyMetricsDoc.OperationType.ITERATE);
    }

    @Override
    public CloseableSilently measureGetLatency() {
        return MicrometerUtil.timer((Timer)this.get, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    @Override
    public CloseableSilently measurePutLatency() {
        return MicrometerUtil.timer((Timer)this.put, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    @Override
    public CloseableSilently measureDeleteLatency() {
        return MicrometerUtil.timer((Timer)this.delete, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    @Override
    public CloseableSilently measureIterateLatency() {
        return MicrometerUtil.timer((Timer)this.iterate, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    private Timer createTimer(String columnFamily, ColumnFamilyMetricsDoc.OperationType type) {
        return Timer.builder((String)ColumnFamilyMetricsDoc.LATENCY.getName()).description(ColumnFamilyMetricsDoc.LATENCY.getDescription()).serviceLevelObjectives(ColumnFamilyMetricsDoc.LATENCY.getTimerSLOs()).tags(new String[]{ColumnFamilyMetricsDoc.ColumnFamilyMetricsKeyName.COLUMN_FAMILY.asString(), columnFamily, ColumnFamilyMetricsDoc.ColumnFamilyMetricsKeyName.OPERATION.asString(), type.getName()}).register(this.registry);
    }
}

