/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.protocol.EnumValue;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZeebeRocksDBMetricExporter<ColumnFamilyType extends Enum<? extends EnumValue>> {
    private static final Logger LOG = LoggerFactory.getLogger((String)ZeebeRocksDBMetricExporter.class.getName());
    private static final String ZEEBE_NAMESPACE = "zeebe";
    private static final String MEMORY_METRICS_HELP = "Everything which might be related to current memory consumption of RocksDB per column family and partition";
    private static final String MEMORY_METRICS_PREFIX = "rocksdb.memory";
    private static final RocksDBMetric[] MEMORY_METRICS = new RocksDBMetric[]{new RocksDBMetric("rocksdb.cur-size-all-mem-tables", "rocksdb.memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition"), new RocksDBMetric("rocksdb.cur-size-active-mem-table", "rocksdb.memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition"), new RocksDBMetric("rocksdb.size-all-mem-tables", "rocksdb.memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition"), new RocksDBMetric("rocksdb.block-cache-usage", "rocksdb.memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition"), new RocksDBMetric("rocksdb.block-cache-capacity", "rocksdb.memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition"), new RocksDBMetric("rocksdb.block-cache-pinned-usage", "rocksdb.memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition"), new RocksDBMetric("rocksdb.estimate-table-readers-mem", "rocksdb.memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition")};
    private static final String SST_METRICS_HELP = "Everything which is related to SST files in RocksDB per column family and partition";
    private static final String SST_METRICS_PREFIX = "rocksdb.sst";
    private static final RocksDBMetric[] SST_METRICS = new RocksDBMetric[]{new RocksDBMetric("rocksdb.total-sst-files-size", "rocksdb.sst", "Everything which is related to SST files in RocksDB per column family and partition"), new RocksDBMetric("rocksdb.live-sst-files-size", "rocksdb.sst", "Everything which is related to SST files in RocksDB per column family and partition")};
    private static final String LIVE_METRICS_HELP = "Other estimated properties based on entries in RocksDb per column family and partition";
    private static final String LIVE_METRICS_PREFIX = "rocksdb.live";
    private static final RocksDBMetric[] LIVE_METRICS = new RocksDBMetric[]{new RocksDBMetric("rocksdb.num-entries-imm-mem-tables", "rocksdb.live", "Other estimated properties based on entries in RocksDb per column family and partition"), new RocksDBMetric("rocksdb.estimate-num-keys", "rocksdb.live", "Other estimated properties based on entries in RocksDb per column family and partition"), new RocksDBMetric("rocksdb.estimate-live-data-size", "rocksdb.live", "Other estimated properties based on entries in RocksDb per column family and partition")};
    private static final String WRITE_METRICS_HELP = "Properties related to writes, flushes and compactions for RocksDb per column family and partition";
    private static final String WRITE_METRICS_PREFIX = "rocksdb.writes";
    private static final RocksDBMetric[] WRITE_METRICS = new RocksDBMetric[]{new RocksDBMetric("rocksdb.is-write-stopped", "rocksdb.writes", "Properties related to writes, flushes and compactions for RocksDb per column family and partition"), new RocksDBMetric("rocksdb.actual-delayed-write-rate", "rocksdb.writes", "Properties related to writes, flushes and compactions for RocksDb per column family and partition"), new RocksDBMetric("rocksdb.mem-table-flush-pending", "rocksdb.writes", "Properties related to writes, flushes and compactions for RocksDb per column family and partition"), new RocksDBMetric("rocksdb.num-running-flushes", "rocksdb.writes", "Properties related to writes, flushes and compactions for RocksDb per column family and partition"), new RocksDBMetric("rocksdb.num-running-compactions", "rocksdb.writes", "Properties related to writes, flushes and compactions for RocksDb per column family and partition")};
    private static final RocksDBMetric[] ALL_METRICS = (RocksDBMetric[])Stream.of(MEMORY_METRICS, LIVE_METRICS, SST_METRICS, WRITE_METRICS).flatMap(Arrays::stream).toArray(RocksDBMetric[]::new);
    private final ZeebeDb<ColumnFamilyType> database;

    public ZeebeRocksDBMetricExporter(ZeebeDb<ColumnFamilyType> database, MeterRegistry meterRegistry) {
        this.database = database;
        ZeebeRocksDBMetricExporter.forAllMetrics(metric -> metric.register(meterRegistry));
    }

    public static ExtendedMeterDocumentation[] allMeterDocumentations() {
        return ALL_METRICS;
    }

    private static void forAllMetrics(Consumer<RocksDBMetric> consumer) {
        for (RocksDBMetric metric : ALL_METRICS) {
            consumer.accept(metric);
        }
    }

    public void exportMetrics() {
        long startTime = System.currentTimeMillis();
        ZeebeRocksDBMetricExporter.forAllMetrics(this::exportMetric);
        long elapsedTime = System.currentTimeMillis() - startTime;
        LOG.trace("Exporting RocksDBMetrics took + {} ms", (Object)elapsedTime);
    }

    private void exportMetric(RocksDBMetric metric) {
        try {
            this.database.getProperty(metric.getPropertyName()).map(Double::parseDouble).ifPresent(metric::exportValue);
        }
        catch (Exception exception) {
            LOG.debug("Error occurred on exporting metric {}", (Object)metric.getPropertyName(), (Object)exception);
        }
    }

    private static final class RocksDBMetric
    implements ExtendedMeterDocumentation {
        private final String propertyName;
        private final String namePrefix;
        private final String help;
        private volatile double value;

        private RocksDBMetric(String propertyName, String namePrefix, String help) {
            this.propertyName = Objects.requireNonNull(propertyName);
            this.namePrefix = namePrefix;
            this.help = help;
        }

        public void register(MeterRegistry registry) {
            Gauge.builder((String)this.getName(), () -> this.value).description(this.help).register(registry);
        }

        private String gaugeSuffix() {
            String suffix = "." + this.propertyName.substring(this.propertyName.indexOf(".") + 1);
            return suffix.replaceAll("-", ".");
        }

        public void exportValue(Double value) {
            this.value = value;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDescription() {
            return this.help;
        }

        public String getName() {
            return "zeebe." + this.namePrefix + this.gaugeSuffix();
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
}

