/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb.transaction;

import io.camunda.zeebe.db.AccessMetricsConfiguration;
import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.ColumnFamilyMetrics;
import io.camunda.zeebe.db.ConsistencyChecksSettings;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.ZeebeDbException;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.FineGrainedColumnFamilyMetrics;
import io.camunda.zeebe.db.impl.NoopColumnFamilyMetrics;
import io.camunda.zeebe.db.impl.rocksdb.Loggers;
import io.camunda.zeebe.db.impl.rocksdb.RocksDbConfiguration;
import io.camunda.zeebe.db.impl.rocksdb.ZeebeRocksDBMetricExporter;
import io.camunda.zeebe.db.impl.rocksdb.ZeebeRocksDbFactory;
import io.camunda.zeebe.db.impl.rocksdb.transaction.DbNullKey;
import io.camunda.zeebe.db.impl.rocksdb.transaction.DefaultTransactionContext;
import io.camunda.zeebe.db.impl.rocksdb.transaction.RocksDbInternal;
import io.camunda.zeebe.db.impl.rocksdb.transaction.RocksDbOptions;
import io.camunda.zeebe.db.impl.rocksdb.transaction.TransactionRenovator;
import io.camunda.zeebe.db.impl.rocksdb.transaction.TransactionalColumnFamily;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ZeebeTransaction;
import io.camunda.zeebe.protocol.EnumValue;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.camunda.zeebe.util.micrometer.StatefulMeterRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.rocksdb.Checkpoint;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.OptimisticTransactionDB;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;
import org.rocksdb.Transaction;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;

public class ZeebeTransactionDb<ColumnFamilyNames extends Enum<? extends EnumValue>>
implements ZeebeDb<ColumnFamilyNames>,
TransactionRenovator {
    private static final Logger LOG = Loggers.DB_LOGGER;
    private static final String ERROR_MESSAGE_CLOSE_RESOURCE = "Expected to close RocksDB resource successfully, but exception was thrown. Will continue to close remaining resources.";
    private final OptimisticTransactionDB optimisticTransactionDB;
    private final List<AutoCloseable> closeables;
    private final ReadOptions prefixReadOptions;
    private final ReadOptions defaultReadOptions;
    private final WriteOptions defaultWriteOptions;
    private final ColumnFamilyHandle defaultHandle;
    private final long defaultNativeHandle;
    private final ConsistencyChecksSettings consistencyChecksSettings;
    private final AccessMetricsConfiguration accessMetricsConfiguration;
    private final StatefulMeterRegistry meterRegistry;
    private final ZeebeRocksDBMetricExporter<ColumnFamilyNames> metricExporter;

    protected ZeebeTransactionDb(ColumnFamilyHandle defaultHandle, OptimisticTransactionDB optimisticTransactionDB, List<AutoCloseable> closeables, RocksDbConfiguration rocksDbConfiguration, ConsistencyChecksSettings consistencyChecksSettings, AccessMetricsConfiguration accessMetricsConfiguration, StatefulMeterRegistry meterRegistry) {
        this.defaultHandle = defaultHandle;
        this.defaultNativeHandle = ZeebeTransactionDb.getNativeHandle((RocksObject)defaultHandle);
        this.optimisticTransactionDB = optimisticTransactionDB;
        this.closeables = closeables;
        this.consistencyChecksSettings = consistencyChecksSettings;
        this.accessMetricsConfiguration = accessMetricsConfiguration;
        this.meterRegistry = meterRegistry;
        this.metricExporter = new ZeebeRocksDBMetricExporter(this, (MeterRegistry)meterRegistry);
        this.prefixReadOptions = new ReadOptions().setPrefixSameAsStart(true).setTotalOrderSeek(false).setReadaheadSize(0L);
        closeables.add((AutoCloseable)this.prefixReadOptions);
        this.defaultReadOptions = new ReadOptions();
        closeables.add((AutoCloseable)this.defaultReadOptions);
        this.defaultWriteOptions = new WriteOptions().setDisableWAL(rocksDbConfiguration.isWalDisabled());
        closeables.add((AutoCloseable)this.defaultWriteOptions);
    }

    public static <ColumnFamilyNames extends Enum<? extends EnumValue>> ZeebeTransactionDb<ColumnFamilyNames> openTransactionalDb(RocksDbOptions options, String path, List<AutoCloseable> closables, RocksDbConfiguration rocksDbConfiguration, ConsistencyChecksSettings consistencyChecksSettings, AccessMetricsConfiguration metrics, ZeebeRocksDbFactory.StatefulMeterRegistryProvider meterRegistryProvider) throws RocksDBException {
        List<ColumnFamilyDescriptor> cfDescriptors = List.of(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, options.cfOptions()));
        ArrayList cfHandles = new ArrayList();
        OptimisticTransactionDB optimisticTransactionDB = OptimisticTransactionDB.open((DBOptions)options.dbOptions(), (String)path, cfDescriptors, cfHandles);
        closables.add((AutoCloseable)optimisticTransactionDB);
        if (cfHandles.size() != 1) {
            throw new IllegalStateException("Expected a handle for the default column family but found %d handles".formatted(cfHandles.size()));
        }
        ColumnFamilyHandle defaultColumnFamilyHandle = (ColumnFamilyHandle)cfHandles.getFirst();
        closables.add((AutoCloseable)defaultColumnFamilyHandle);
        StatefulMeterRegistry statefulMeterRegistry = meterRegistryProvider.createMeterRegistry();
        closables.add(() -> MicrometerUtil.discard((CompositeMeterRegistry)statefulMeterRegistry));
        return new ZeebeTransactionDb<ColumnFamilyNames>(defaultColumnFamilyHandle, optimisticTransactionDB, closables, rocksDbConfiguration, consistencyChecksSettings, metrics, statefulMeterRegistry);
    }

    static long getNativeHandle(RocksObject object) {
        try {
            return RocksDbInternal.nativeHandle.getLong(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unexpected error occurred trying to access private nativeHandle_ field", e);
        }
    }

    protected ReadOptions getPrefixReadOptions() {
        return this.prefixReadOptions;
    }

    protected ColumnFamilyHandle getDefaultHandle() {
        return this.defaultHandle;
    }

    protected long getReadOptionsNativeHandle() {
        return ZeebeTransactionDb.getNativeHandle((RocksObject)this.defaultReadOptions);
    }

    protected long getDefaultNativeHandle() {
        return this.defaultNativeHandle;
    }

    @Override
    public <KeyType extends DbKey, ValueType extends DbValue> ColumnFamily<KeyType, ValueType> createColumnFamily(ColumnFamilyNames columnFamily, TransactionContext context, KeyType keyInstance, ValueType valueInstance) {
        ColumnFamilyMetrics metrics = switch (this.accessMetricsConfiguration.kind()) {
            default -> throw new MatchException(null, null);
            case AccessMetricsConfiguration.Kind.NONE -> new NoopColumnFamilyMetrics();
            case AccessMetricsConfiguration.Kind.FINE -> new FineGrainedColumnFamilyMetrics(columnFamily, (MeterRegistry)this.meterRegistry);
        };
        return new TransactionalColumnFamily<ColumnFamilyNames, KeyType, ValueType>(this, this.consistencyChecksSettings, columnFamily, context, keyInstance, valueInstance, metrics);
    }

    @Override
    public void createSnapshot(File snapshotDir) {
        try (Checkpoint checkpoint = Checkpoint.create((RocksDB)this.optimisticTransactionDB);){
            try {
                checkpoint.createCheckpoint(snapshotDir.getAbsolutePath());
            }
            catch (RocksDBException rocksException) {
                throw new ZeebeDbException(String.format("Failed to take snapshot in path %s.", snapshotDir), rocksException);
            }
        }
    }

    @Override
    public Optional<String> getProperty(String propertyName) {
        String propertyValue = null;
        try {
            propertyValue = this.optimisticTransactionDB.getProperty(this.defaultHandle, propertyName);
        }
        catch (RocksDBException rde) {
            LOG.debug(rde.getMessage(), (Throwable)rde);
        }
        return Optional.ofNullable(propertyValue);
    }

    @Override
    public TransactionContext createContext() {
        Transaction transaction = this.optimisticTransactionDB.beginTransaction(this.defaultWriteOptions);
        ZeebeTransaction zeebeTransaction = new ZeebeTransaction(transaction, this);
        this.closeables.add(zeebeTransaction);
        return new DefaultTransactionContext(zeebeTransaction);
    }

    @Override
    public boolean isEmpty(ColumnFamilyNames columnFamilyName, TransactionContext context) {
        return this.createColumnFamily(columnFamilyName, context, (KeyType)DbNullKey.INSTANCE, (ValueType)DbNil.INSTANCE).isEmpty();
    }

    @Override
    public StatefulMeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public void exportMetrics() {
        this.metricExporter.exportMetrics();
    }

    @Override
    public Transaction renewTransaction(Transaction oldTransaction) {
        return this.optimisticTransactionDB.beginTransaction(this.defaultWriteOptions, oldTransaction);
    }

    @Override
    public void close() {
        Collections.reverse(this.closeables);
        this.closeables.forEach(closable -> {
            try {
                closable.close();
            }
            catch (Exception e) {
                LOG.error(ERROR_MESSAGE_CLOSE_RESOURCE, (Throwable)e);
            }
        });
    }
}

