/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dispatcher.impl.log;

import io.camunda.zeebe.dispatcher.impl.log.LogBufferDescriptor;
import org.agrona.concurrent.UnsafeBuffer;

public class LogBufferPartition {
    protected final int partitionSize;
    protected final UnsafeBuffer dataBuffer;
    protected final UnsafeBuffer metadataBuffer;
    protected final int rawBufferOffset;

    public LogBufferPartition(UnsafeBuffer dataBuffer, UnsafeBuffer metadataBuffer, int rawBufferOffset) {
        dataBuffer.verifyAlignment();
        metadataBuffer.verifyAlignment();
        this.dataBuffer = dataBuffer;
        this.metadataBuffer = metadataBuffer;
        this.partitionSize = dataBuffer.capacity();
        this.rawBufferOffset = rawBufferOffset;
        dataBuffer.setMemory(0, this.partitionSize, (byte)0);
    }

    public void clean() {
        this.dataBuffer.setMemory(0, this.partitionSize, (byte)0);
        this.metadataBuffer.putInt(LogBufferDescriptor.PARTITION_TAIL_COUNTER_OFFSET, 0);
        this.setStatusOrdered(0);
    }

    public UnsafeBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public int getTailCounterVolatile() {
        return this.metadataBuffer.getIntVolatile(LogBufferDescriptor.PARTITION_TAIL_COUNTER_OFFSET);
    }

    public int getAndAddTail(int frameLength) {
        return this.metadataBuffer.getAndAddInt(LogBufferDescriptor.PARTITION_TAIL_COUNTER_OFFSET, frameLength);
    }

    public int getPartitionSize() {
        return this.partitionSize;
    }

    public void setStatusOrdered(int status) {
        this.metadataBuffer.putIntOrdered(LogBufferDescriptor.PARTITION_STATUS_OFFSET, status);
    }

    public int getStatusVolatile() {
        return this.metadataBuffer.getIntVolatile(LogBufferDescriptor.PARTITION_STATUS_OFFSET);
    }

    public boolean needsCleaning() {
        return this.getStatusVolatile() == 1;
    }

    public int getUnderlyingBufferOffset() {
        return this.rawBufferOffset;
    }
}

