/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dispatcher;

import java.util.concurrent.atomic.AtomicLong;

public class AtomicPosition {
    private final AtomicLong position = new AtomicLong(0L);

    public void reset() {
        this.set(-1L);
    }

    public long get() {
        return this.position.get();
    }

    public void set(long value) {
        this.position.set(value);
    }

    public boolean proposeMaxOrdered(long newValue) {
        boolean updated = false;
        while (!updated) {
            long currentPosition = this.position.get();
            if (currentPosition < newValue) {
                updated = this.position.compareAndSet(currentPosition, newValue);
                continue;
            }
            return false;
        }
        return updated;
    }
}

