/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dispatcher;

import io.camunda.zeebe.dispatcher.AtomicPosition;
import io.camunda.zeebe.dispatcher.Dispatcher;
import io.camunda.zeebe.dispatcher.impl.log.LogBuffer;
import io.camunda.zeebe.dispatcher.impl.log.LogBufferAppender;
import io.camunda.zeebe.dispatcher.impl.log.LogBufferDescriptor;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.util.ByteValue;
import io.camunda.zeebe.util.EnsureUtil;
import io.camunda.zeebe.util.allocation.AllocatedBuffer;
import io.camunda.zeebe.util.allocation.BufferAllocators;
import java.util.Objects;
import org.agrona.BitUtil;

public final class DispatcherBuilder {
    private static final int DEFAULT_BUFFER_SIZE = (int)ByteValue.ofMegabytes((long)1L);
    private int bufferSize = -1;
    private int maxFragmentLength = -1;
    private String dispatcherName;
    private ActorSchedulingService actorSchedulingService;
    private String[] subscriptionNames;
    private long initialPosition = 1L;

    public DispatcherBuilder(String dispatcherName) {
        this.dispatcherName = dispatcherName;
    }

    public DispatcherBuilder name(String name) {
        this.dispatcherName = name;
        return this;
    }

    public DispatcherBuilder bufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public DispatcherBuilder actorSchedulingService(ActorSchedulingService actorSchedulingService) {
        this.actorSchedulingService = actorSchedulingService;
        return this;
    }

    public DispatcherBuilder maxFragmentLength(int maxFragmentLength) {
        this.maxFragmentLength = maxFragmentLength;
        return this;
    }

    public DispatcherBuilder initialPosition(long initialPosition) {
        EnsureUtil.ensureGreaterThanOrEqual((String)"initial position", (long)initialPosition, (long)1L);
        this.initialPosition = initialPosition;
        return this;
    }

    public DispatcherBuilder subscriptions(String ... subscriptionNames) {
        this.subscriptionNames = subscriptionNames;
        return this;
    }

    public Dispatcher build() {
        int logWindowLength;
        Objects.requireNonNull(this.actorSchedulingService, "Actor scheduling service must not be null.");
        this.bufferSize = this.calculateBufferSize();
        int partitionSize = BitUtil.align((int)(this.bufferSize / 3), (int)8);
        this.maxFragmentLength = logWindowLength = partitionSize / 2;
        AllocatedBuffer allocatedBuffer = this.initAllocatedBuffer(this.bufferSize);
        AtomicPosition publisherLimit = new AtomicPosition();
        AtomicPosition publisherPosition = new AtomicPosition();
        LogBuffer logBuffer = new LogBuffer(allocatedBuffer, partitionSize);
        LogBufferAppender logAppender = new LogBufferAppender();
        Dispatcher dispatcher = new Dispatcher(logBuffer, logAppender, publisherLimit, publisherPosition, this.initialPosition, logWindowLength, this.maxFragmentLength, this.subscriptionNames, this.dispatcherName);
        dispatcher.updatePublisherLimit();
        this.actorSchedulingService.submitActor((Actor)dispatcher);
        return dispatcher;
    }

    private int calculateBufferSize() {
        if (this.maxFragmentLength > 0) {
            int partitionSize = BitUtil.align((int)(this.maxFragmentLength * 2), (int)8);
            int requiredBufferSize = partitionSize * 3;
            if (this.bufferSize > 0 && this.bufferSize < requiredBufferSize) {
                throw new IllegalArgumentException(String.format("Expected the buffer size to be greater than %d, but was %d. The max fragment length is set to %d.", requiredBufferSize, this.bufferSize, this.maxFragmentLength));
            }
            return Math.max(this.bufferSize, requiredBufferSize);
        }
        if (this.bufferSize <= 0) {
            return DEFAULT_BUFFER_SIZE;
        }
        return this.bufferSize;
    }

    private AllocatedBuffer initAllocatedBuffer(int partitionSize) {
        int requiredCapacity = LogBufferDescriptor.requiredCapacity(partitionSize);
        return BufferAllocators.allocateDirect((int)requiredCapacity);
    }
}

