/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dmn.impl;

import io.camunda.zeebe.dmn.DecisionContext;
import io.camunda.zeebe.dmn.DecisionEngine;
import io.camunda.zeebe.dmn.DecisionEvaluationResult;
import io.camunda.zeebe.dmn.EvaluatedDecision;
import io.camunda.zeebe.dmn.ParsedDecisionRequirementsGraph;
import io.camunda.zeebe.dmn.impl.EvaluatedDmnScalaDecision;
import io.camunda.zeebe.dmn.impl.EvaluationFailure;
import io.camunda.zeebe.dmn.impl.EvaluationResult;
import io.camunda.zeebe.dmn.impl.ParseFailureMessage;
import io.camunda.zeebe.dmn.impl.ParsedDmnScalaDrg;
import io.camunda.zeebe.feel.impl.FeelToMessagePackTransformer;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.camunda.dmn.Audit;
import org.camunda.dmn.DmnEngine;
import org.camunda.dmn.parser.ParsedDmn;
import org.camunda.feel.syntaxtree.Val;
import scala.util.Either;
import scala.util.Left;

public final class DmnScalaDecisionEngine
implements DecisionEngine {
    private static final DirectBuffer NIL_OUTPUT = BufferUtil.wrapArray((byte[])MsgPackHelper.NIL);
    private final DmnEngine dmnEngine;
    private final FeelToMessagePackTransformer outputConverter = new FeelToMessagePackTransformer();

    public DmnScalaDecisionEngine() {
        this.dmnEngine = new DmnEngine.Builder().build();
    }

    @Override
    public ParsedDecisionRequirementsGraph parse(InputStream dmnResource) {
        if (dmnResource == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        try {
            Either parseResult = this.dmnEngine.parse(dmnResource);
            if (parseResult.isLeft()) {
                DmnEngine.Failure failure = (DmnEngine.Failure)parseResult.left().get();
                String failureMessage = failure.message();
                return new ParseFailureMessage(failureMessage);
            }
            ParsedDmn parsedDmn = (ParsedDmn)parseResult.right().get();
            return ParsedDmnScalaDrg.of(parsedDmn);
        }
        catch (Exception e) {
            String failureMessage = e.getMessage();
            return new ParseFailureMessage(failureMessage);
        }
    }

    @Override
    public DecisionEvaluationResult evaluateDecisionById(ParsedDecisionRequirementsGraph decisionRequirementsGraph, String decisionId, DecisionContext context) {
        Objects.requireNonNull(decisionRequirementsGraph);
        Objects.requireNonNull(decisionId);
        DecisionContext evalContext = Objects.requireNonNullElse(context, Map::of);
        if (!decisionRequirementsGraph.isValid()) {
            return new EvaluationFailure(String.format("Expected to evaluate decision '%s', but the decision requirements graph is invalid", decisionId));
        }
        ParsedDmn parsedDmn = ((ParsedDmnScalaDrg)decisionRequirementsGraph).getParsedDmn();
        Either<DmnEngine.EvalFailure, DmnEngine.EvalResult> result = this.tryEval(decisionId, parsedDmn, evalContext);
        Audit.AuditLog auditLog = (Audit.AuditLog)result.map(DmnEngine.EvalResult::auditLog).getOrElse(() -> ((DmnEngine.EvalFailure)result.left().get()).auditLog());
        List<EvaluatedDecision> evaluatedDecisions = Optional.ofNullable(auditLog).map(this::getEvaluatedDecisions).orElse(List.of());
        if (result.isLeft()) {
            String reason = ((DmnEngine.EvalFailure)result.left().get()).failure().message();
            String failedDecisionId = null;
            if (!evaluatedDecisions.isEmpty()) {
                failedDecisionId = evaluatedDecisions.get(evaluatedDecisions.size() - 1).decisionId();
            }
            return new EvaluationFailure(String.format("Expected to evaluate decision '%s', but %s", decisionId, reason), failedDecisionId, evaluatedDecisions);
        }
        DmnEngine.EvalResult evalResult = (DmnEngine.EvalResult)result.right().get();
        if (evalResult.isNil()) {
            return new EvaluationResult(NIL_OUTPUT, evaluatedDecisions);
        }
        Object output = evalResult.value();
        if (output instanceof Val) {
            Val val = (Val)output;
            return new EvaluationResult(this.toMessagePack(val), evaluatedDecisions);
        }
        throw new IllegalStateException(String.format("Expected DMN evaluation result to be of type '%s' but was '%s'", Val.class, output.getClass()));
    }

    private Either<DmnEngine.EvalFailure, DmnEngine.EvalResult> tryEval(String decisionId, ParsedDmn parsedDmn, DecisionContext context) {
        try {
            return this.dmnEngine.eval(parsedDmn, decisionId, context.toMap());
        }
        catch (NoSuchElementException e) {
            if (e.getMessage().equals("last of empty list")) {
                String message = String.format("no decision found for '%s'", decisionId);
                return Left.apply((Object)new DmnEngine.EvalFailure(new DmnEngine.Failure(message), null));
            }
            throw e;
        }
    }

    private List<EvaluatedDecision> getEvaluatedDecisions(Audit.AuditLog auditLog) {
        ArrayList<EvaluatedDecision> evaluatedDecisions = new ArrayList<EvaluatedDecision>();
        auditLog.entries().foreach(auditLogEntry -> {
            EvaluatedDmnScalaDecision evaluatedDecision = EvaluatedDmnScalaDecision.of(auditLogEntry, this::toMessagePack);
            return evaluatedDecisions.add(evaluatedDecision);
        });
        return evaluatedDecisions;
    }

    private DirectBuffer toMessagePack(Val value) {
        DirectBuffer reusedBuffer = this.outputConverter.toMessagePack(value);
        return BufferUtil.cloneBuffer((DirectBuffer)reusedBuffer);
    }
}

