/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dmn.impl;

import io.camunda.zeebe.dmn.DecisionType;
import io.camunda.zeebe.dmn.EvaluatedDecision;
import io.camunda.zeebe.dmn.EvaluatedInput;
import io.camunda.zeebe.dmn.MatchedRule;
import io.camunda.zeebe.dmn.impl.EvaluatedDmnScalaInput;
import io.camunda.zeebe.dmn.impl.MatchedDmnScalaRule;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.camunda.dmn.Audit;
import org.camunda.dmn.parser.ParsedContext;
import org.camunda.dmn.parser.ParsedDecisionLogic;
import org.camunda.dmn.parser.ParsedDecisionTable;
import org.camunda.dmn.parser.ParsedInvocation;
import org.camunda.dmn.parser.ParsedList;
import org.camunda.dmn.parser.ParsedLiteralExpression;
import org.camunda.dmn.parser.ParsedRelation;
import org.camunda.dmn.parser.ParsedRule;
import org.camunda.feel.syntaxtree.Val;
import scala.collection.immutable.List;

public record EvaluatedDmnScalaDecision(String decisionId, String decisionName, DecisionType decisionType, DirectBuffer decisionOutput, java.util.List<EvaluatedInput> evaluatedInputs, java.util.List<MatchedRule> matchedRules) implements EvaluatedDecision
{
    private static final Map<Class<? extends ParsedDecisionLogic>, DecisionType> DECISION_TYPE_MAPPING = Map.ofEntries(Map.entry(ParsedDecisionTable.class, DecisionType.DECISION_TABLE), Map.entry(ParsedLiteralExpression.class, DecisionType.LITERAL_EXPRESSION), Map.entry(ParsedContext.class, DecisionType.CONTEXT), Map.entry(ParsedList.class, DecisionType.LIST), Map.entry(ParsedRelation.class, DecisionType.RELATION), Map.entry(ParsedInvocation.class, DecisionType.INVOCATION));

    public static EvaluatedDmnScalaDecision of(Audit.AuditLogEntry auditLogEntry, Function<Val, DirectBuffer> converter) {
        DecisionType decisionType = EvaluatedDmnScalaDecision.getDecisionType(auditLogEntry.decisionLogic());
        Audit.EvaluationResult evaluationResult = auditLogEntry.result();
        DirectBuffer decisionOutput = converter.apply(evaluationResult.result());
        ArrayList<EvaluatedInput> evaluatedInputs = new ArrayList<EvaluatedInput>();
        ArrayList<MatchedRule> matchedRules = new ArrayList<MatchedRule>();
        if (evaluationResult instanceof Audit.DecisionTableEvaluationResult) {
            Audit.DecisionTableEvaluationResult decisionTableResult = (Audit.DecisionTableEvaluationResult)evaluationResult;
            decisionTableResult.inputs().foreach(input -> {
                EvaluatedDmnScalaInput evaluatedInput = EvaluatedDmnScalaInput.of(input, converter);
                return evaluatedInputs.add(evaluatedInput);
            });
            decisionTableResult.matchedRules().foreach(evaluatedRule -> {
                MatchedDmnScalaRule matchedRule = MatchedDmnScalaRule.of(evaluatedRule, EvaluatedDmnScalaDecision.getRuleIndex(auditLogEntry.decisionLogic(), evaluatedRule.rule()), converter);
                return matchedRules.add(matchedRule);
            });
        }
        return new EvaluatedDmnScalaDecision(auditLogEntry.id(), auditLogEntry.name(), decisionType, decisionOutput, evaluatedInputs, matchedRules);
    }

    private static DecisionType getDecisionType(ParsedDecisionLogic decisionLogic) {
        return DECISION_TYPE_MAPPING.getOrDefault(decisionLogic.getClass(), DecisionType.UNKNOWN);
    }

    private static int getRuleIndex(ParsedDecisionLogic decisionLogic, ParsedRule rule) {
        if (decisionLogic instanceof ParsedDecisionTable) {
            ParsedDecisionTable decisionTable = (ParsedDecisionTable)decisionLogic;
            List rules = decisionTable.rules().toList();
            return rules.indexOf((Object)rule) + 1;
        }
        return -1;
    }
}

