/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import io.camunda.zeebe.exporter.ElasticsearchExporterConfiguration;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.util.VersionUtil;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

final class RecordIndexRouter {
    private static final String INDEX_DELIMITER = "_";
    private static final String ALIAS_DELIMITER = "-";
    private final DateTimeFormatter formatter;
    private final ElasticsearchExporterConfiguration.IndexConfiguration config;

    RecordIndexRouter(ElasticsearchExporterConfiguration.IndexConfiguration config) {
        this(config, DateTimeFormatter.ofPattern(config.indexSuffixDatePattern).withZone(ZoneOffset.UTC));
    }

    RecordIndexRouter(ElasticsearchExporterConfiguration.IndexConfiguration config, DateTimeFormatter formatter) {
        this.config = config;
        this.formatter = formatter;
    }

    String indexFor(Record<?> record) {
        Instant timestamp = Instant.ofEpochMilli(record.getTimestamp());
        return this.indexPrefixForValueType(record.getValueType()) + INDEX_DELIMITER + this.formatter.format(timestamp);
    }

    String idFor(Record<?> record) {
        return record.getPartitionId() + ALIAS_DELIMITER + record.getPosition();
    }

    String aliasNameForValueType(ValueType valueType) {
        return this.config.prefix + ALIAS_DELIMITER + this.valueTypeToString(valueType);
    }

    String indexPrefixForValueType(ValueType valueType) {
        String version = VersionUtil.getVersionLowerCase();
        return this.config.prefix + INDEX_DELIMITER + this.valueTypeToString(valueType) + INDEX_DELIMITER + version;
    }

    String searchPatternForValueType(ValueType valueType) {
        return this.indexPrefixForValueType(valueType) + "_*";
    }

    String routingFor(Record<?> record) {
        return String.valueOf(record.getPartitionId());
    }

    private String valueTypeToString(ValueType valueType) {
        return valueType.name().toLowerCase().replace(INDEX_DELIMITER, ALIAS_DELIMITER);
    }
}

