/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.test;

import io.camunda.zeebe.exporter.api.context.Configuration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.jcip.annotations.Immutable;

@Immutable
public final class ExporterTestConfiguration<T>
implements Configuration {
    private final String id;
    private final Map<String, Object> arguments;
    private final Function<Map<String, Object>, T> configurationSupplier;

    public ExporterTestConfiguration(String id, T configuration) {
        this(id, ignored -> configuration);
    }

    public ExporterTestConfiguration(String id, Function<Map<String, Object>, T> configurationSupplier) {
        this(id, Collections.emptyMap(), configurationSupplier);
    }

    public ExporterTestConfiguration(String id, Map<String, Object> arguments, Function<Map<String, Object>, T> configurationSupplier) {
        this.id = Objects.requireNonNull(id, "must specify an ID");
        this.arguments = Objects.requireNonNull(arguments, "must specify arguments");
        this.configurationSupplier = Objects.requireNonNull(configurationSupplier, "must specific a configurationSupplier");
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public <R> R instantiate(Class<R> configClass) {
        Objects.requireNonNull(configClass, "must pass a non null configClass");
        T configuration = this.configurationSupplier.apply(this.arguments);
        return configClass.cast(configuration);
    }
}

