/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.test;

import io.camunda.zeebe.exporter.api.context.Configuration;
import io.camunda.zeebe.exporter.api.context.Context;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.InstantSource;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class ExporterTestContext
implements Context {
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(ExporterTestContext.class);
    private Configuration configuration;
    private Context.RecordFilter recordFilter;
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public Logger getLogger() {
        return DEFAULT_LOGGER;
    }

    public InstantSource clock() {
        return InstantSource.system();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public int getPartitionId() {
        return 0;
    }

    public void setFilter(Context.RecordFilter filter) {
        this.recordFilter = filter;
    }

    public ExporterTestContext setConfiguration(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "must specify a configuration");
        return this;
    }

    public Context.RecordFilter getRecordFilter() {
        return this.recordFilter;
    }
}

