/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.test;

import io.camunda.zeebe.exporter.api.context.Controller;
import io.camunda.zeebe.exporter.api.context.ScheduledTask;
import io.camunda.zeebe.exporter.test.ExporterTestScheduledTask;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class ExporterTestController
implements Controller {
    private static final long UNKNOWN_POSITION = -1L;
    private final AtomicLong position = new AtomicLong(-1L);
    private final List<ExporterTestScheduledTask> scheduledTasks = new CopyOnWriteArrayList<ExporterTestScheduledTask>();
    private volatile long lastRanAtMs = 0L;
    private final AtomicReference<Optional<byte[]>> exporterMetadata = new AtomicReference(Optional.empty());

    public void updateLastExportedRecordPosition(long position) {
        this.position.getAndAccumulate(position, Math::max);
    }

    public void updateLastExportedRecordPosition(long position, byte[] metadata) {
        long previousValue = this.position.getAndAccumulate(position, Math::max);
        if (position >= previousValue) {
            this.exporterMetadata.set(Optional.of(metadata));
        }
    }

    public long getLastExportedRecordPosition() {
        return this.getPosition();
    }

    public synchronized ScheduledTask scheduleCancellableTask(Duration delay, Runnable task) {
        ExporterTestScheduledTask scheduledTask = new ExporterTestScheduledTask(Objects.requireNonNull(delay, "must specify a task delay"), Objects.requireNonNull(task, "must specify a task"));
        this.scheduledTasks.add(scheduledTask);
        return scheduledTask;
    }

    public Optional<byte[]> readMetadata() {
        return this.exporterMetadata.get();
    }

    public synchronized void resetScheduledTasks() {
        this.lastRanAtMs = 0L;
        this.scheduledTasks.clear();
    }

    public long getPosition() {
        return this.position.get();
    }

    public List<ExporterTestScheduledTask> getScheduledTasks() {
        return this.scheduledTasks;
    }

    public Instant getLastRanAt() {
        return Instant.ofEpochMilli(this.lastRanAtMs);
    }

    public synchronized void runScheduledTasks(Duration elapsed) {
        Objects.requireNonNull(elapsed, "must specify a tick duration");
        Duration upperBound = elapsed.plusMillis(this.lastRanAtMs);
        this.scheduledTasks.stream().filter(t -> t.getDelay().compareTo(upperBound) <= 0).filter(t -> !t.isCanceled()).sorted(Comparator.comparing(ExporterTestScheduledTask::getDelay)).forEach(ExporterTestScheduledTask::run);
        this.lastRanAtMs = upperBound.toMillis();
    }
}

