/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.test;

import io.camunda.zeebe.exporter.api.context.ScheduledTask;
import java.time.Duration;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class ExporterTestScheduledTask
implements ScheduledTask,
Runnable {
    private final Duration delay;
    private final Runnable task;
    private volatile boolean isExecuted;
    private volatile boolean isCanceled;

    public ExporterTestScheduledTask(Duration delay, Runnable task) {
        this.delay = Objects.requireNonNull(delay, "must specify a task delay");
        this.task = Objects.requireNonNull(task, "must specify a task");
    }

    public Duration getDelay() {
        return this.delay;
    }

    public Runnable getTask() {
        return this.task;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public boolean wasExecuted() {
        return this.isExecuted;
    }

    @Override
    public synchronized void run() {
        if (this.isCanceled || this.isExecuted) {
            return;
        }
        this.task.run();
        this.isExecuted = true;
    }

    public synchronized void cancel() {
        if (this.isCanceled || this.isExecuted) {
            return;
        }
        this.isCanceled = true;
    }
}

