/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.feel.impl;

import io.camunda.zeebe.feel.impl.Loggers;
import io.camunda.zeebe.feel.impl.MessagePackContext;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.camunda.feel.context.Context;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValBoolean;
import org.camunda.feel.syntaxtree.ValContext;
import org.camunda.feel.syntaxtree.ValDate;
import org.camunda.feel.syntaxtree.ValDateTime;
import org.camunda.feel.syntaxtree.ValDayTimeDuration;
import org.camunda.feel.syntaxtree.ValList;
import org.camunda.feel.syntaxtree.ValLocalDateTime;
import org.camunda.feel.syntaxtree.ValLocalTime;
import org.camunda.feel.syntaxtree.ValNull$;
import org.camunda.feel.syntaxtree.ValNumber;
import org.camunda.feel.syntaxtree.ValString;
import org.camunda.feel.syntaxtree.ValTime;
import org.camunda.feel.syntaxtree.ValYearMonthDuration;
import org.camunda.feel.syntaxtree.ZonedTime;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005%4A!\u0004\b\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0013)\u0003B\u0002\u0018\u0001A\u0003%a\u0005C\u00040\u0001\t\u0007I\u0011\u0002\u0019\t\re\u0002\u0001\u0015!\u00032\u0011\u001dQ\u0004A1A\u0005\nmBaA\u0011\u0001!\u0002\u0013a\u0004bB\"\u0001\u0005\u0004%Ia\u000f\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001f\t\u000b\u0015\u0003A\u0011\u0001$\t\u000bQ\u0003A\u0011B+\t\u000bi\u0003A\u0011B.\u00039\u0019+W\r\u001c+p\u001b\u0016\u001c8/Y4f!\u0006\u001c7\u000e\u0016:b]N4wN]7fe*\u0011q\u0002E\u0001\u0005S6\u0004HN\u0003\u0002\u0012%\u0005!a-Z3m\u0015\t\u0019B#A\u0003{K\u0016\u0014WM\u0003\u0002\u0016-\u000591-Y7v]\u0012\f'\"A\f\u0002\u0005%|7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\u000f\u0003\u00199(/\u001b;feV\ta\u0005\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005!1\u000f]3d\u0015\tY##A\u0004ng\u001e\u0004\u0018mY6\n\u00055B#!D'tOB\u000b7m[,sSR,'/A\u0004xe&$XM\u001d\u0011\u0002\u0017]\u0014\u0018\u000e^3Ck\u001a4WM]\u000b\u0002cA\u0011!gN\u0007\u0002g)\u0011A'N\u0001\u0007C\u001e\u0014xN\\1\u000b\u0003Y\n1a\u001c:h\u0013\tA4GA\u000bFqB\fg\u000eZ1cY\u0016\f%O]1z\u0005V4g-\u001a:\u0002\u0019]\u0014\u0018\u000e^3Ck\u001a4WM\u001d\u0011\u0002\u0015I,7/\u001e7u-&,w/F\u0001=!\ti\u0004)D\u0001?\u0015\ty4'\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u0011 \u0003\u0019Us7/\u00194f\u0005V4g-\u001a:\u0002\u0017I,7/\u001e7u-&,w\u000fI\u0001\u000egR\u0014\u0018N\\4Xe\u0006\u0004\b/\u001a:\u0002\u001dM$(/\u001b8h/J\f\u0007\u000f]3sA\u0005iAo\\'fgN\fw-\u001a)bG.$\"a\u0012&\u0011\u0005IB\u0015BA%4\u00051!\u0015N]3di\n+hMZ3s\u0011\u0015Y%\u00021\u0001M\u0003\u00151\u0018\r\\;f!\ti%+D\u0001O\u0015\ty\u0005+\u0001\u0006ts:$\u0018\r\u001f;sK\u0016T!!E)\u000b\u0005U)\u0014BA*O\u0005\r1\u0016\r\\\u0001\u000boJLG/\u001a,bYV,GC\u0001,Z!\tYr+\u0003\u0002Y9\t!QK\\5u\u0011\u0015Y5\u00021\u0001M\u0003A9(/\u001b;f'R\u0014\u0018N\\4WC2,X\r\u0006\u0002'9\")Q\f\u0004a\u0001=\u000611\u000f\u001e:j]\u001e\u0004\"a\u00184\u000f\u0005\u0001$\u0007CA1\u001d\u001b\u0005\u0011'BA2\u0019\u0003\u0019a$o\\8u}%\u0011Q\rH\u0001\u0007!J,G-\u001a4\n\u0005\u001dD'AB*ue&twM\u0003\u0002f9\u0001")
public class FeelToMessagePackTransformer {
    private final MsgPackWriter writer = new MsgPackWriter();
    private final ExpandableArrayBuffer writeBuffer = new ExpandableArrayBuffer();
    private final UnsafeBuffer resultView = new UnsafeBuffer();
    private final UnsafeBuffer stringWrapper = new UnsafeBuffer();

    private MsgPackWriter writer() {
        return this.writer;
    }

    private ExpandableArrayBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private UnsafeBuffer resultView() {
        return this.resultView;
    }

    private UnsafeBuffer stringWrapper() {
        return this.stringWrapper;
    }

    public DirectBuffer toMessagePack(Val value) {
        this.writer().wrap((MutableDirectBuffer)this.writeBuffer(), 0);
        this.writeValue(value);
        this.resultView().wrap((DirectBuffer)this.writeBuffer(), 0, this.writer().getOffset());
        return this.resultView();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeValue(Val value2) {
        boolean bl = false;
        ValNumber valNumber = null;
        boolean bl2 = false;
        ValContext valContext = null;
        Val val = value2;
        if (ValNull$.MODULE$.equals(val)) {
            this.writer().writeNil();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValNumber) {
            bl = true;
            valNumber = (ValNumber)val;
            BigDecimal number = valNumber.value();
            if (number.isWhole()) {
                this.writer().writeInteger(number.longValue());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            BigDecimal number = valNumber.value();
            this.writer().writeFloat(number.doubleValue());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValBoolean) {
            ValBoolean valBoolean = (ValBoolean)val;
            boolean bl3 = valBoolean.value();
            this.writer().writeBoolean(bl3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValString) {
            ValString valString = (ValString)val;
            String string = valString.value();
            this.writeStringValue(string);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValList) {
            ValList valList = (ValList)val;
            List items = valList.items();
            this.writer().writeArrayHeader(items.size());
            items.foreach((Function1 & Serializable)value -> {
                this.writeValue(value);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValContext) {
            bl2 = true;
            valContext = (ValContext)val;
            Context context = valContext.context();
            if (context instanceof MessagePackContext) {
                MessagePackContext messagePackContext = (MessagePackContext)context;
                this.writer().writeRaw(messagePackContext.messagePackMap());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl2) {
            Context context = valContext.context();
            Map variables = context.variableProvider().getVariables();
            this.writer().writeMapHeader(variables.size());
            variables.foreach((Function1 & Serializable)x0$1 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    this.stringWrapper().wrap(key.getBytes());
                    this.writer().writeString((DirectBuffer)this.stringWrapper());
                    Object object = value;
                    if (object instanceof Val) {
                        Val val = (Val)object;
                        this.writeValue(val);
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof DirectBuffer) {
                        DirectBuffer directBuffer = (DirectBuffer)object;
                        boxedUnit = this.writer().writeRaw(directBuffer);
                    } else {
                        this.writer().writeNil();
                        Loggers.LOGGER.trace("No FEEL to MessagePack transformation for '{}'. Using 'null' for context entry with key '{}'.", object, (Object)key);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValTime) {
            ValTime valTime = (ValTime)val;
            ZonedTime time = valTime.value();
            this.writeStringValue(time.format());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValLocalTime) {
            ValLocalTime valLocalTime = (ValLocalTime)val;
            LocalTime time = valLocalTime.value();
            this.writeStringValue(time.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValDate) {
            ValDate valDate = (ValDate)val;
            LocalDate date = valDate.value();
            this.writeStringValue(date.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValDateTime) {
            ValDateTime valDateTime = (ValDateTime)val;
            ZonedDateTime dateTime = valDateTime.value();
            this.writeStringValue(dateTime.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValLocalDateTime) {
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
            LocalDateTime dateTime = valLocalDateTime.value();
            this.writeStringValue(dateTime.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValDayTimeDuration) {
            ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val;
            Duration duration = valDayTimeDuration.value();
            this.writeStringValue(duration.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (val instanceof ValYearMonthDuration) {
            ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val;
            Period duration = valYearMonthDuration.value();
            this.writeStringValue(duration.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        this.writer().writeNil();
        Loggers.LOGGER.trace("No FEEL to MessagePack transformation for '{}'. Using 'null' instead.", (Object)val);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private MsgPackWriter writeStringValue(String string) {
        this.stringWrapper().wrap(string.getBytes());
        return this.writer().writeString((DirectBuffer)this.stringWrapper());
    }
}

