/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="Changeset", description="A map of changes.")
public class Changeset {
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String dueDate = null;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String followUpDate = null;
    @Valid
    private List<String> candidateUsers;
    @Valid
    private List<String> candidateGroups;
    private Map<String, Object> additionalProperties;

    public Changeset dueDate(String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Valid
    @Schema(name="dueDate", description="The due date of the task. Reset by providing an empty String.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="dueDate")
    public String getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public Changeset followUpDate(String followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    @Valid
    @Schema(name="followUpDate", description="The follow-up date of the task. Reset by providing an empty String.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="followUpDate")
    public String getFollowUpDate() {
        return this.followUpDate;
    }

    public void setFollowUpDate(String followUpDate) {
        this.followUpDate = followUpDate;
    }

    public Changeset candidateUsers(List<String> candidateUsers) {
        this.candidateUsers = candidateUsers;
        return this;
    }

    public Changeset addCandidateUsersItem(String candidateUsersItem) {
        if (this.candidateUsers == null) {
            this.candidateUsers = new ArrayList<String>();
        }
        this.candidateUsers.add(candidateUsersItem);
        return this;
    }

    @Schema(name="candidateUsers", description="The list of candidate users of the task. Reset by providing an empty list.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="candidateUsers")
    public List<String> getCandidateUsers() {
        return this.candidateUsers;
    }

    public void setCandidateUsers(List<String> candidateUsers) {
        this.candidateUsers = candidateUsers;
    }

    public Changeset candidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public Changeset addCandidateGroupsItem(String candidateGroupsItem) {
        if (this.candidateGroups == null) {
            this.candidateGroups = new ArrayList<String>();
        }
        this.candidateGroups.add(candidateGroupsItem);
        return this;
    }

    @Schema(name="candidateGroups", description="The list of candidate groups of the task. Reset by providing an empty list.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="candidateGroups")
    public List<String> getCandidateGroups() {
        return this.candidateGroups;
    }

    public void setCandidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
    }

    @JsonAnySetter
    public Changeset putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Changeset changeset = (Changeset)o;
        return Objects.equals(this.dueDate, changeset.dueDate) && Objects.equals(this.followUpDate, changeset.followUpDate) && Objects.equals(this.candidateUsers, changeset.candidateUsers) && Objects.equals(this.candidateGroups, changeset.candidateGroups) && Objects.equals(this.additionalProperties, changeset.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.dueDate, this.followUpDate, this.candidateUsers, this.candidateGroups, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Changeset {\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    followUpDate: ").append(this.toIndentedString(this.followUpDate)).append("\n");
        sb.append("    candidateUsers: ").append(this.toIndentedString(this.candidateUsers)).append("\n");
        sb.append("    candidateGroups: ").append(this.toIndentedString(this.candidateGroups)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

