/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="Partition", description="Provides information on a partition within a broker node.")
public class Partition {
    private Integer partitionId;
    private RoleEnum role;
    private HealthEnum health;

    public Partition partitionId(Integer partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    @Schema(name="partitionId", description="The unique ID of this partition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="partitionId")
    public Integer getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(Integer partitionId) {
        this.partitionId = partitionId;
    }

    public Partition role(RoleEnum role) {
        this.role = role;
        return this;
    }

    @Schema(name="role", description="Describes the Raft role of the broker for a given partition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="role")
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public Partition health(HealthEnum health) {
        this.health = health;
        return this;
    }

    @Schema(name="health", description="Describes the current health of the partition.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="health")
    public HealthEnum getHealth() {
        return this.health;
    }

    public void setHealth(HealthEnum health) {
        this.health = health;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition partition = (Partition)o;
        return Objects.equals(this.partitionId, partition.partitionId) && Objects.equals((Object)this.role, (Object)partition.role) && Objects.equals((Object)this.health, (Object)partition.health);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitionId, this.role, this.health});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Partition {\n");
        sb.append("    partitionId: ").append(this.toIndentedString(this.partitionId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    health: ").append(this.toIndentedString((Object)this.health)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RoleEnum {
        LEADER("leader"),
        FOLLOWER("follower"),
        INACTIVE("inactive");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum HealthEnum {
        HEALTHY("healthy"),
        UNHEALTHY("unhealthy"),
        DEAD("dead");

        private String value;

        private HealthEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HealthEnum fromValue(String value) {
            for (HealthEnum b : HealthEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

