/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.net.URI;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="ProblemDetail", description="A Problem detail object as described in [RFC 9457](https://www.rfc-editor.org/rfc/rfc9457). There may be additional properties specific to the problem type. ")
public class ProblemDetail {
    private URI type = URI.create("about:blank");
    private String title;
    private Integer status;
    private String detail;
    private URI instance;

    public ProblemDetail type(URI type) {
        this.type = type;
        return this;
    }

    @Valid
    @Schema(name="type", description="A URI identifying the problem type.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public URI getType() {
        return this.type;
    }

    public void setType(URI type) {
        this.type = type;
    }

    public ProblemDetail title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="A summary of the problem type.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ProblemDetail status(Integer status) {
        this.status = status;
        return this;
    }

    @Min(value=400L)
    @Max(value=600L)
    @Schema(name="status", description="The HTTP status code for this problem.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="status")
    public @Min(value=400L) @Max(value=600L) Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public ProblemDetail detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Schema(name="detail", description="An explanation of the problem in more detail.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="detail")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public ProblemDetail instance(URI instance) {
        this.instance = instance;
        return this;
    }

    @Valid
    @Schema(name="instance", description="A URI identifying the origin of the problem.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="instance")
    public URI getInstance() {
        return this.instance;
    }

    public void setInstance(URI instance) {
        this.instance = instance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProblemDetail problemDetail = (ProblemDetail)o;
        return Objects.equals(this.type, problemDetail.type) && Objects.equals(this.title, problemDetail.title) && Objects.equals(this.status, problemDetail.status) && Objects.equals(this.detail, problemDetail.detail) && Objects.equals(this.instance, problemDetail.instance);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.title, this.status, this.detail, this.instance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProblemDetail {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    instance: ").append(this.toIndentedString(this.instance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

