/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserTaskCompletionRequest {
    @Valid
    private Map<String, Object> variables;
    private String action = null;

    public UserTaskCompletionRequest variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public UserTaskCompletionRequest putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Schema(name="variables", description="The variables to complete the user task with.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="variables")
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public UserTaskCompletionRequest action(String action) {
        this.action = action;
        return this;
    }

    @Schema(name="action", description="A custom action value that will be accessible from user task events resulting from this endpoint invocation. If not provided, it will default to \"complete\". ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="action")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTaskCompletionRequest userTaskCompletionRequest = (UserTaskCompletionRequest)o;
        return Objects.equals(this.variables, userTaskCompletionRequest.variables) && Objects.equals(this.action, userTaskCompletionRequest.action);
    }

    public int hashCode() {
        return Objects.hash(this.variables, this.action);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserTaskCompletionRequest {\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

