/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(name="UserTaskUpdateRequest_changeset", description="JSON object with changed task attribute values.  The following attributes can be adjusted with this endpoint, additional attributes will be ignored:  * `candidateGroups` - reset by providing an empty list * `candidateUsers` - reset by providing an empty list * `dueDate` - reset by providing an empty String * `followUpDate` - reset by providing an empty String  Providing any of those attributes with a `null` value or omitting it preserves the persisted attribute's value.  The assignee cannot be adjusted with this endpoint, use the Assign task endpoint. This ensures correct event emission for assignee changes. ")
@JsonTypeName(value="UserTaskUpdateRequest_changeset")
public class UserTaskUpdateRequestChangeset {
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String dueDate = null;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private String followUpDate = null;
    @Valid
    private List<String> candidateUsers;
    @Valid
    private List<String> candidateGroups;

    public UserTaskUpdateRequestChangeset dueDate(String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Valid
    @Schema(name="dueDate", description="The due date of the task. Reset by providing an empty String.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="dueDate")
    public String getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public UserTaskUpdateRequestChangeset followUpDate(String followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    @Valid
    @Schema(name="followUpDate", description="The follow-up date of the task. Reset by providing an empty String.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="followUpDate")
    public String getFollowUpDate() {
        return this.followUpDate;
    }

    public void setFollowUpDate(String followUpDate) {
        this.followUpDate = followUpDate;
    }

    public UserTaskUpdateRequestChangeset candidateUsers(List<String> candidateUsers) {
        this.candidateUsers = candidateUsers;
        return this;
    }

    public UserTaskUpdateRequestChangeset addCandidateUsersItem(String candidateUsersItem) {
        if (this.candidateUsers == null) {
            this.candidateUsers = new ArrayList<String>();
        }
        this.candidateUsers.add(candidateUsersItem);
        return this;
    }

    @Schema(name="candidateUsers", description="The list of candidate users of the task. Reset by providing an empty list.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="candidateUsers")
    public List<String> getCandidateUsers() {
        return this.candidateUsers;
    }

    public void setCandidateUsers(List<String> candidateUsers) {
        this.candidateUsers = candidateUsers;
    }

    public UserTaskUpdateRequestChangeset candidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public UserTaskUpdateRequestChangeset addCandidateGroupsItem(String candidateGroupsItem) {
        if (this.candidateGroups == null) {
            this.candidateGroups = new ArrayList<String>();
        }
        this.candidateGroups.add(candidateGroupsItem);
        return this;
    }

    @Schema(name="candidateGroups", description="The list of candidate groups of the task. Reset by providing an empty list.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="candidateGroups")
    public List<String> getCandidateGroups() {
        return this.candidateGroups;
    }

    public void setCandidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTaskUpdateRequestChangeset userTaskUpdateRequestChangeset = (UserTaskUpdateRequestChangeset)o;
        return Objects.equals(this.dueDate, userTaskUpdateRequestChangeset.dueDate) && Objects.equals(this.followUpDate, userTaskUpdateRequestChangeset.followUpDate) && Objects.equals(this.candidateUsers, userTaskUpdateRequestChangeset.candidateUsers) && Objects.equals(this.candidateGroups, userTaskUpdateRequestChangeset.candidateGroups);
    }

    public int hashCode() {
        return Objects.hash(this.dueDate, this.followUpDate, this.candidateUsers, this.candidateGroups);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserTaskUpdateRequestChangeset {\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    followUpDate: ").append(this.toIndentedString(this.followUpDate)).append("\n");
        sb.append("    candidateUsers: ").append(this.toIndentedString(this.candidateUsers)).append("\n");
        sb.append("    candidateGroups: ").append(this.toIndentedString(this.candidateGroups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

