/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest;

import java.net.URI;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;

@ControllerAdvice(annotations={RestController.class})
public class GlobalControllerExceptionHandler {
    @ExceptionHandler(value={ServerWebInputException.class})
    public ResponseEntity<ProblemDetail> handleServerWebInputExceptions(ServerWebInputException ex, ServerWebExchange context) {
        ProblemDetail problemDetail = ProblemDetail.forStatus((HttpStatusCode)ex.getStatusCode());
        problemDetail.setTitle(ex.getReason());
        if (ex.getCause() != null) {
            problemDetail.setDetail(ex.getCause().getMessage());
        } else {
            problemDetail.setDetail(ex.getMessage());
        }
        problemDetail.setInstance(URI.create(context.getRequest().getPath().toString()));
        return ResponseEntity.of((ProblemDetail)problemDetail).build();
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ProblemDetail> handleAllExceptions(Exception ex, ServerWebExchange context) {
        ProblemDetail problemDetail = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, (String)ex.getMessage());
        problemDetail.setInstance(URI.create(context.getRequest().getPath().toString()));
        return ResponseEntity.of((ProblemDetail)problemDetail).build();
    }
}

