/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest;

import io.camunda.zeebe.auth.impl.Authorization;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskAssignmentRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskCompletionRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskUpdateRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskUpdateRequestChangeset;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.TenantAttributeHolder;
import io.camunda.zeebe.gateway.rest.impl.broker.request.BrokerUserTaskAssignmentRequest;
import io.camunda.zeebe.gateway.rest.impl.broker.request.BrokerUserTaskCompletionRequest;
import io.camunda.zeebe.gateway.rest.impl.broker.request.BrokerUserTaskUpdateRequest;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.util.Either;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.web.server.ServerWebExchange;

public class RequestMapper {
    private static final String ERROR_MESSAGE_EMPTY_ASSIGNEE = "No assignee provided";
    private static final String ERROR_MESSAGE_DATE_PARSING = "The provided %s '%s' cannot be parsed as a date according to RFC 3339, section 5.6.";
    private static final String ERROR_MESSAGE_EMPTY_UPDATE_CHANGESET = "No update data provided. Provide at least an \"action\" or a non-null value for a supported attribute in the \"changeset\".";

    public static Either<ProblemDetail, BrokerUserTaskCompletionRequest> toUserTaskCompletionRequest(UserTaskCompletionRequest completionRequest, long userTaskKey, ServerWebExchange context) {
        BrokerUserTaskCompletionRequest brokerRequest = new BrokerUserTaskCompletionRequest(userTaskKey, RequestMapper.getDocumentOrEmpty(completionRequest, UserTaskCompletionRequest::getVariables), RequestMapper.getStringOrEmpty(completionRequest, UserTaskCompletionRequest::getAction));
        String authorizationToken = RequestMapper.getAuthorizationToken(context);
        brokerRequest.setAuthorization(authorizationToken);
        return Either.right((Object)((Object)brokerRequest));
    }

    public static Either<ProblemDetail, BrokerUserTaskAssignmentRequest> toUserTaskAssignmentRequest(UserTaskAssignmentRequest assignmentRequest, long userTaskKey, ServerWebExchange context) {
        Optional<ProblemDetail> validationErrorResponse = RequestMapper.validateAssignmentRequest(assignmentRequest);
        if (validationErrorResponse.isPresent()) {
            return Either.left((Object)validationErrorResponse.get());
        }
        String action = RequestMapper.getStringOrEmpty(assignmentRequest, UserTaskAssignmentRequest::getAction);
        if (action.isBlank()) {
            action = "assign";
        }
        UserTaskIntent intent = assignmentRequest.getAllowOverride() == null || assignmentRequest.getAllowOverride() != false ? UserTaskIntent.ASSIGN : UserTaskIntent.CLAIM;
        BrokerUserTaskAssignmentRequest brokerRequest = new BrokerUserTaskAssignmentRequest(userTaskKey, assignmentRequest.getAssignee(), action, intent);
        String authorizationToken = RequestMapper.getAuthorizationToken(context);
        brokerRequest.setAuthorization(authorizationToken);
        return Either.right((Object)((Object)brokerRequest));
    }

    public static Either<ProblemDetail, BrokerUserTaskAssignmentRequest> toUserTaskUnassignmentRequest(long userTaskKey, ServerWebExchange context) {
        BrokerUserTaskAssignmentRequest brokerRequest = new BrokerUserTaskAssignmentRequest(userTaskKey, "", "unassign", UserTaskIntent.ASSIGN);
        String authorizationToken = RequestMapper.getAuthorizationToken(context);
        brokerRequest.setAuthorization(authorizationToken);
        return Either.right((Object)((Object)brokerRequest));
    }

    public static Either<ProblemDetail, BrokerUserTaskUpdateRequest> toUserTaskUpdateRequest(UserTaskUpdateRequest updateRequest, long userTaskKey, ServerWebExchange context) {
        Optional<ProblemDetail> validationErrorResponse = RequestMapper.validateUpdateRequest(updateRequest);
        if (validationErrorResponse.isPresent()) {
            return Either.left((Object)validationErrorResponse.get());
        }
        BrokerUserTaskUpdateRequest brokerRequest = new BrokerUserTaskUpdateRequest(userTaskKey, RequestMapper.getRecordWithChangedAttributes(updateRequest), RequestMapper.getStringOrEmpty(updateRequest, UserTaskUpdateRequest::getAction));
        brokerRequest.setAuthorization(RequestMapper.getAuthorizationToken(context));
        return Either.right((Object)((Object)brokerRequest));
    }

    private static Optional<ProblemDetail> validateAssignmentRequest(UserTaskAssignmentRequest assignmentRequest) {
        if (assignmentRequest.getAssignee() == null || assignmentRequest.getAssignee().isBlank()) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, ERROR_MESSAGE_EMPTY_ASSIGNEE, RejectionType.INVALID_ARGUMENT.name());
            return Optional.of(problemDetail);
        }
        return Optional.empty();
    }

    private static Optional<ProblemDetail> validateUpdateRequest(UserTaskUpdateRequest updateRequest) {
        ArrayList<String> violations = new ArrayList<String>();
        if (updateRequest == null || updateRequest.getAction() == null && RequestMapper.isEmpty(updateRequest.getChangeset())) {
            violations.add(ERROR_MESSAGE_EMPTY_UPDATE_CHANGESET);
        }
        if (updateRequest != null && !RequestMapper.isEmpty(updateRequest.getChangeset())) {
            UserTaskUpdateRequestChangeset changeset = updateRequest.getChangeset();
            RequestMapper.validateDate(changeset.getDueDate(), "due date", violations);
            RequestMapper.validateDate(changeset.getFollowUpDate(), "follow-up date", violations);
        }
        if (violations.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, String.join((CharSequence)" ", violations), RejectionType.INVALID_ARGUMENT.name()));
    }

    private static void validateDate(String dateString, String attributeName, List<String> violations) {
        if (dateString != null && !dateString.isEmpty()) {
            try {
                ZonedDateTime.parse(dateString);
            }
            catch (DateTimeParseException ex) {
                violations.add(ERROR_MESSAGE_DATE_PARSING.formatted(attributeName, dateString));
            }
        }
    }

    private static boolean isEmpty(UserTaskUpdateRequestChangeset changeset) {
        return changeset == null || changeset.getFollowUpDate() == null && changeset.getDueDate() == null && changeset.getCandidateGroups() == null && changeset.getCandidateUsers() == null;
    }

    private static String getAuthorizationToken(ServerWebExchange context) {
        List<String> authorizedTenants = TenantAttributeHolder.tenantIds(context);
        return Authorization.jwtEncoder().withIssuer("zeebe-gateway").withAudience("zeebe-broker").withSubject("zeebe-client").withClaim("authorized_tenants", authorizedTenants).encode();
    }

    private static UserTaskRecord getRecordWithChangedAttributes(UserTaskUpdateRequest updateRequest) {
        UserTaskRecord record = new UserTaskRecord();
        if (updateRequest == null || updateRequest.getChangeset() == null) {
            return record;
        }
        UserTaskUpdateRequestChangeset changeset = updateRequest.getChangeset();
        if (changeset.getCandidateGroups() != null) {
            record.setCandidateGroupsList(changeset.getCandidateGroups()).setCandidateGroupsChanged();
        }
        if (changeset.getCandidateUsers() != null) {
            record.setCandidateUsersList(changeset.getCandidateUsers()).setCandidateUsersChanged();
        }
        if (changeset.getDueDate() != null) {
            record.setDueDate(changeset.getDueDate()).setDueDateChanged();
        }
        if (changeset.getFollowUpDate() != null) {
            record.setFollowUpDate(changeset.getFollowUpDate()).setFollowUpDateChanged();
        }
        return record;
    }

    private static DirectBuffer getDocumentOrEmpty(UserTaskCompletionRequest request, Function<UserTaskCompletionRequest, Map<String, Object>> variablesExtractor) {
        Map<String, Object> value = request == null ? null : variablesExtractor.apply(request);
        return value == null || value.isEmpty() ? DocumentValue.EMPTY_DOCUMENT : new UnsafeBuffer(MsgPackConverter.convertToMsgPack(value));
    }

    private static <R> String getStringOrEmpty(R request, Function<R, String> valueExtractor) {
        String value = request == null ? null : valueExtractor.apply(request);
        return value == null ? "" : value;
    }
}

