/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest;

import com.fasterxml.jackson.core.JsonParseException;
import io.atomix.cluster.messaging.MessagingException;
import io.camunda.zeebe.broker.client.api.BrokerErrorException;
import io.camunda.zeebe.broker.client.api.BrokerRejectionException;
import io.camunda.zeebe.broker.client.api.PartitionNotFoundException;
import io.camunda.zeebe.broker.client.api.RequestRetriesExhaustedException;
import io.camunda.zeebe.broker.client.api.dto.BrokerError;
import io.camunda.zeebe.broker.client.api.dto.BrokerRejection;
import io.camunda.zeebe.broker.client.api.dto.BrokerResponse;
import io.camunda.zeebe.gateway.cmd.ConcurrentRequestException;
import io.camunda.zeebe.msgpack.spec.MsgpackException;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.netty.channel.ConnectTimeoutException;
import java.lang.runtime.SwitchBootstraps;
import java.net.ConnectException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;

public class RestErrorMapper {
    private static final Logger REST_GATEWAY_LOGGER = LoggerFactory.getLogger((String)"io.camunda.zeebe.gateway.rest");

    public static <T> Optional<ResponseEntity<T>> getResponse(BrokerResponse<?> brokerResponse, Throwable error, Function<BrokerRejection, ProblemDetail> rejectionMapper) {
        return Optional.ofNullable(error).map(e -> RestErrorMapper.mapErrorToProblem(e, rejectionMapper)).or(() -> RestErrorMapper.mapBrokerErrorToProblem(brokerResponse)).or(() -> RestErrorMapper.mapRejectionToProblem(brokerResponse, rejectionMapper)).map(RestErrorMapper::mapProblemToResponse);
    }

    private static ProblemDetail mapErrorToProblem(Throwable error, Function<BrokerRejection, ProblemDetail> rejectionMapper) {
        if (error == null) {
            return null;
        }
        Throwable throwable = error;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BrokerErrorException.class, BrokerRejectionException.class, ExecutionException.class, CompletionException.class, MsgpackException.class, JsonParseException.class, IllegalArgumentException.class, RequestRetriesExhaustedException.class, TimeoutException.class, MessagingException.ConnectionClosed.class, ConnectTimeoutException.class, ConnectException.class, PartitionNotFoundException.class, ConcurrentRequestException.class}, (Object)throwable2, n)) {
            case 0 -> {
                BrokerErrorException bee = (BrokerErrorException)throwable2;
                yield RestErrorMapper.mapBrokerErrorToProblem(error, bee.getError());
            }
            case 1 -> {
                BrokerRejectionException bre = (BrokerRejectionException)throwable2;
                REST_GATEWAY_LOGGER.trace("Expected to handle REST request, but the broker rejected it", error);
                yield rejectionMapper.apply(bre.getRejection());
            }
            case 2 -> {
                ExecutionException ee = (ExecutionException)throwable2;
                yield RestErrorMapper.mapErrorToProblem(ee.getCause(), rejectionMapper);
            }
            case 3 -> {
                CompletionException ce = (CompletionException)throwable2;
                yield RestErrorMapper.mapErrorToProblem(ce.getCause(), rejectionMapper);
            }
            case 4 -> {
                MsgpackException mpe = (MsgpackException)throwable2;
                String mpeMsg = "Expected to handle REST API request, but messagepack property was invalid";
                REST_GATEWAY_LOGGER.debug("Expected to handle REST API request, but messagepack property was invalid", (Throwable)mpe);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, "Expected to handle REST API request, but messagepack property was invalid", mpe.getClass().getName());
            }
            case 5 -> {
                JsonParseException jpe = (JsonParseException)throwable2;
                String jpeMsg = "Expected to handle REST API request, but JSON property was invalid";
                REST_GATEWAY_LOGGER.debug("Expected to handle REST API request, but JSON property was invalid", (Throwable)jpe);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, "Expected to handle REST API request, but JSON property was invalid", jpe.getClass().getName());
            }
            case 6 -> {
                IllegalArgumentException iae = (IllegalArgumentException)throwable2;
                String iaeMsg = "Expected to handle REST API request, but JSON property was invalid";
                REST_GATEWAY_LOGGER.debug("Expected to handle REST API request, but JSON property was invalid", (Throwable)iae);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, "Expected to handle REST API request, but JSON property was invalid", iae.getClass().getName());
            }
            case 7 -> {
                RequestRetriesExhaustedException rree = (RequestRetriesExhaustedException)throwable2;
                String rreeMsg = "Expected to handle REST API request, but all retries have been exhausted";
                REST_GATEWAY_LOGGER.trace("Expected to handle REST API request, but all retries have been exhausted", (Throwable)rree);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.TOO_MANY_REQUESTS, "Expected to handle REST API request, but all retries have been exhausted", rree.getClass().getName());
            }
            case 8 -> {
                TimeoutException te = (TimeoutException)throwable2;
                String teMsg = "Expected to handle REST API request, but request timed out between gateway and broker";
                REST_GATEWAY_LOGGER.debug("Expected to handle REST API request, but request timed out between gateway and broker", (Throwable)te);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT, "Expected to handle REST API request, but request timed out between gateway and broker", te.getClass().getName());
            }
            case 9 -> {
                MessagingException.ConnectionClosed cc = (MessagingException.ConnectionClosed)throwable2;
                String ccMsg = "Expected to handle REST API request, but the connection was cut prematurely with the broker; the request may or may not have been accepted, and may not be safe to retry";
                REST_GATEWAY_LOGGER.warn("Expected to handle REST API request, but the connection was cut prematurely with the broker; the request may or may not have been accepted, and may not be safe to retry", (Throwable)cc);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_GATEWAY, "Expected to handle REST API request, but the connection was cut prematurely with the broker; the request may or may not have been accepted, and may not be safe to retry", cc.getClass().getName());
            }
            case 10 -> {
                ConnectTimeoutException cte = (ConnectTimeoutException)throwable2;
                String cteMsg = "Expected to handle REST API request, but a connection timeout exception occurred";
                REST_GATEWAY_LOGGER.warn("Expected to handle REST API request, but a connection timeout exception occurred", (Throwable)cte);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "Expected to handle REST API request, but a connection timeout exception occurred", cte.getClass().getName());
            }
            case 11 -> {
                ConnectException ce = (ConnectException)throwable2;
                String ceMsg = "Expected to handle REST API request, but there was a connection error with one of the brokers";
                REST_GATEWAY_LOGGER.warn("Expected to handle REST API request, but there was a connection error with one of the brokers", (Throwable)ce);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "Expected to handle REST API request, but there was a connection error with one of the brokers", ce.getClass().getName());
            }
            case 12 -> {
                PartitionNotFoundException pnfe = (PartitionNotFoundException)throwable2;
                String pnfeMsg = "Expected to handle REST API request, but request could not be delivered";
                REST_GATEWAY_LOGGER.debug("Expected to handle REST API request, but request could not be delivered", (Throwable)pnfe);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "Expected to handle REST API request, but request could not be delivered", pnfe.getClass().getName());
            }
            case 13 -> {
                ConcurrentRequestException cre = (ConcurrentRequestException)throwable2;
                String creMsg = "Expected to handle REST API request, but the request was rejected";
                REST_GATEWAY_LOGGER.debug("Expected to handle REST API request, but the request was rejected", (Throwable)cre);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "Expected to handle REST API request, but the request was rejected", cre.getClass().getName());
            }
            default -> {
                REST_GATEWAY_LOGGER.error("Expected to handle REST API request, but an unexpected error occurred", error);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Unexpected error occurred during the request processing: " + error.getMessage(), error.getClass().getName());
            }
        };
    }

    private static Optional<ProblemDetail> mapBrokerErrorToProblem(BrokerResponse<?> brokerResponse) {
        if (brokerResponse.isError()) {
            return Optional.ofNullable(RestErrorMapper.mapBrokerErrorToProblem(null, brokerResponse.getError()));
        }
        return Optional.empty();
    }

    private static ProblemDetail mapBrokerErrorToProblem(Throwable rootError, BrokerError error) {
        if (error == null) {
            return null;
        }
        String message = error.getMessage();
        String title = error.code().name();
        return switch (error.getCode()) {
            case ErrorCode.PROCESS_NOT_FOUND -> RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.NOT_FOUND, message, title);
            case ErrorCode.RESOURCE_EXHAUSTED -> {
                REST_GATEWAY_LOGGER.trace("Target broker is currently overloaded: {}", (Object)error, (Object)rootError);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.TOO_MANY_REQUESTS, message, title);
            }
            case ErrorCode.PARTITION_LEADER_MISMATCH -> {
                REST_GATEWAY_LOGGER.trace("Target broker was not the leader of the partition: {}", (Object)error, (Object)rootError);
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, message, title);
            }
            default -> {
                REST_GATEWAY_LOGGER.error("Expected to handle REST request, but received an internal error from broker: {}", (Object)error, (Object)rootError);
                message = String.format("Received an unexpected error from the broker, code: %s, message: %s", error.getCode(), error.getMessage());
                yield RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, message, title);
            }
        };
    }

    private static Optional<ProblemDetail> mapRejectionToProblem(BrokerResponse<?> brokerResponse, Function<BrokerRejection, ProblemDetail> rejectionMapper) {
        if (brokerResponse.isRejection()) {
            return Optional.ofNullable(rejectionMapper.apply(brokerResponse.getRejection()));
        }
        return Optional.empty();
    }

    public static ProblemDetail createProblemDetail(HttpStatusCode status, String detail, String title) {
        ProblemDetail problemDetail = ProblemDetail.forStatusAndDetail((HttpStatusCode)status, (String)detail);
        problemDetail.setTitle(title);
        return problemDetail;
    }

    public static <T> ResponseEntity<T> mapProblemToResponse(ProblemDetail problemDetail) {
        return ResponseEntity.of((ProblemDetail)problemDetail).headers(httpHeaders -> httpHeaders.setContentType(MediaType.APPLICATION_PROBLEM_JSON)).build();
    }
}

